--TEST--
Testing array_slice() parameter parsing
--FILE--
<?php

require_once('array_slice.inc');

// Zero args
echo "\n*** Output for zero arguments ***\n";
array_slice();

// Single arg: array
echo "\n*** Output for single array argument ***\n";
array_slice($var_array);

// First arg: scalar
echo "\n*** Output for scalar first argument ***\n";
array_slice($int, 2);

// First arg: string
echo "\n*** Output for string first argument ***\n";
array_slice($str, 2);

// First arg: object
echo "\n*** Output for object first argument ***\n";
array_slice($obj, 2);

// Second arg: array
echo "\n*** Output for non-scalar second argument ***\n";
array_slice($var_array, $arr);

// Third arg: string
echo "\n*** Output for string third argument ***\n";
array_slice($var_array, $int, $str);

// Third arg: array
echo "\n*** Output for non-scalar third argument ***\n";
array_slice($var_array, $int, $arr);

// Fourth arg: array
echo "\n*** Output for non-scalar fourth argument ***\n";
array_slice($var_array, $int, $int, $arr);

// More than the valid number of args
echo "\n*** Output for invalid number of arguments ***\n";
array_slice($var_array, 2, 4, true, 0, 1, 1, 1);

?>

--EXPECTF--
*** Output for zero arguments ***

Warning: array_slice() expects at least %d parameters, %d given in %s on line %d

*** Output for single array argument ***

Warning: array_slice() expects at least %d parameters, %d given in %s on line %d

*** Output for scalar first argument ***

Warning: array_slice() expects parameter %d to be array, integer given in %s on line %d

*** Output for string first argument ***

Warning: array_slice() expects parameter %d to be array, string given in %s on line %d

*** Output for object first argument ***

Warning: array_slice() expects parameter %d to be array, object given in %s on line %d

*** Output for non-scalar second argument ***

Warning: array_slice() expects parameter %d to be long, array given in %s on line %d

*** Output for string third argument ***

Warning: array_slice() expects parameter %d to be long, string given in %s on line %d

*** Output for non-scalar third argument ***

Warning: array_slice() expects parameter %d to be long, array given in %s on line %d

*** Output for non-scalar fourth argument ***

Warning: array_slice() expects parameter %d to be boolean, array given in %s on line %d

*** Output for invalid number of arguments ***

Warning: array_slice() expects at most %d parameters, %d given in %s on line %d
