--TEST--
Testing array_slice() variations with two arguments
--FILE--
<?php

include('array_slice.inc');

$counter = 1;

foreach ($var_array as $sub_array) {
    echo "\n*** Iteration ".$counter." ***\n";

    echo "*** zero offset ***\n";
    var_dump(array_slice($sub_array, 0));

    echo "*** positive offset ***\n";
    var_dump(array_slice($sub_array, 1));

    echo "*** negative offset ***\n";
    var_dump(array_slice($sub_array, -2));

    $counter++;
}

?>

--EXPECTF--
*** Iteration 1 ***
*** zero offset ***
array(0) {
}
*** positive offset ***
array(0) {
}
*** negative offset ***
array(0) {
}

*** Iteration 2 ***
*** zero offset ***
array(9) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
  [3]=>
  int(4)
  [4]=>
  int(5)
  [5]=>
  int(6)
  [6]=>
  int(7)
  [7]=>
  int(8)
  [8]=>
  int(9)
}
*** positive offset ***
array(8) {
  [0]=>
  int(2)
  [1]=>
  int(3)
  [2]=>
  int(4)
  [3]=>
  int(5)
  [4]=>
  int(6)
  [5]=>
  int(7)
  [6]=>
  int(8)
  [7]=>
  int(9)
}
*** negative offset ***
array(2) {
  [0]=>
  int(8)
  [1]=>
  int(9)
}

*** Iteration 3 ***
*** zero offset ***
array(5) {
  [0]=>
  string(3) "One"
  [1]=>
  string(3) "Two"
  [2]=>
  string(5) "Three"
  [3]=>
  string(4) "Four"
  [4]=>
  string(4) "Five"
}
*** positive offset ***
array(4) {
  [0]=>
  string(3) "Two"
  [1]=>
  string(5) "Three"
  [2]=>
  string(4) "Four"
  [3]=>
  string(4) "Five"
}
*** negative offset ***
array(2) {
  [0]=>
  string(4) "Four"
  [1]=>
  string(4) "Five"
}

*** Iteration 4 ***
*** zero offset ***
array(8) {
  [0]=>
  int(6)
  [1]=>
  string(3) "six"
  [2]=>
  int(7)
  [3]=>
  string(5) "seven"
  [4]=>
  int(8)
  [5]=>
  string(5) "eight"
  [6]=>
  int(9)
  [7]=>
  string(4) "nine"
}
*** positive offset ***
array(7) {
  [0]=>
  string(3) "six"
  [1]=>
  int(7)
  [2]=>
  string(5) "seven"
  [3]=>
  int(8)
  [4]=>
  string(5) "eight"
  [5]=>
  int(9)
  [6]=>
  string(4) "nine"
}
*** negative offset ***
array(2) {
  [0]=>
  int(9)
  [1]=>
  string(4) "nine"
}

*** Iteration 5 ***
*** zero offset ***
array(5) {
  ["a"]=>
  string(3) "aaa"
  ["A"]=>
  string(3) "AAA"
  ["c"]=>
  string(3) "ccc"
  ["d"]=>
  string(3) "ddd"
  ["e"]=>
  string(3) "eee"
}
*** positive offset ***
array(4) {
  ["A"]=>
  string(3) "AAA"
  ["c"]=>
  string(3) "ccc"
  ["d"]=>
  string(3) "ddd"
  ["e"]=>
  string(3) "eee"
}
*** negative offset ***
array(2) {
  ["d"]=>
  string(3) "ddd"
  ["e"]=>
  string(3) "eee"
}

*** Iteration 6 ***
*** zero offset ***
array(5) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
  [2]=>
  string(5) "three"
  [3]=>
  string(4) "four"
  [4]=>
  string(4) "five"
}
*** positive offset ***
array(4) {
  [0]=>
  string(3) "two"
  [1]=>
  string(5) "three"
  [2]=>
  string(4) "four"
  [3]=>
  string(4) "five"
}
*** negative offset ***
array(2) {
  [0]=>
  string(4) "four"
  [1]=>
  string(4) "five"
}

*** Iteration 7 ***
*** zero offset ***
array(5) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
  [2]=>
  int(7)
  [3]=>
  string(4) "four"
  [4]=>
  string(4) "five"
}
*** positive offset ***
array(4) {
  [0]=>
  string(3) "two"
  [1]=>
  int(7)
  [2]=>
  string(4) "four"
  [3]=>
  string(4) "five"
}
*** negative offset ***
array(2) {
  [0]=>
  string(4) "four"
  [1]=>
  string(4) "five"
}

*** Iteration 8 ***
*** zero offset ***
array(10) {
  ["f"]=>
  string(3) "fff"
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
  [""]=>
  string(5) "blank"
  [2]=>
  string(5) "float"
  ["F"]=>
  string(3) "FFF"
  ["blank"]=>
  string(0) ""
  [3]=>
  float(3.7)
  [4]=>
  string(4) "Five"
  [5]=>
  float(8.6)
}
*** positive offset ***
array(9) {
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
  [""]=>
  string(5) "blank"
  [2]=>
  string(5) "float"
  ["F"]=>
  string(3) "FFF"
  ["blank"]=>
  string(0) ""
  [3]=>
  float(3.7)
  [4]=>
  string(4) "Five"
  [5]=>
  float(8.6)
}
*** negative offset ***
array(2) {
  [0]=>
  string(4) "Five"
  [1]=>
  float(8.6)
}

*** Iteration 9 ***
*** zero offset ***
array(4) {
  [0]=>
  int(12)
  [1]=>
  string(4) "name"
  [2]=>
  string(3) "age"
  [3]=>
  string(2) "45"
}
*** positive offset ***
array(3) {
  [0]=>
  string(4) "name"
  [1]=>
  string(3) "age"
  [2]=>
  string(2) "45"
}
*** negative offset ***
array(2) {
  [0]=>
  string(3) "age"
  [1]=>
  string(2) "45"
}

*** Iteration 10 ***
*** zero offset ***
array(3) {
  [0]=>
  array(3) {
    [0]=>
    string(3) "oNe"
    [1]=>
    string(3) "tWo"
    [2]=>
    int(4)
  }
  [1]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [2]=>
  array(0) {
  }
}
*** positive offset ***
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [1]=>
  array(0) {
  }
}
*** negative offset ***
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [1]=>
  array(0) {
  }
}
