--TEST--
Testing array_slice() variations with three arguments
--FILE--
<?php

include('array_slice.inc');

$counter = 1;

foreach ($var_array as $sub_array) {
    echo "\n*** Iteration ".$counter." ***\n";

    echo "*** zero offset, variable length ***\n";
    var_dump(array_slice($sub_array, 0, 0));
    var_dump(array_slice($sub_array, 0, 3));
    var_dump(array_slice($sub_array, 0, -3));

    echo "*** positive offset, variable length ***\n";
    var_dump(array_slice($sub_array, 1, 0));
    var_dump(array_slice($sub_array, 1, 3));
    var_dump(array_slice($sub_array, 1, -3));

    echo "*** negative offset, variable length ***\n";
    var_dump(array_slice($sub_array, -2, 0));
    var_dump(array_slice($sub_array, -2, 3));
    var_dump(array_slice($sub_array, -2, -3));

    $counter++;
}

?>

--EXPECTF--
*** Iteration 1 ***
*** zero offset, variable length ***
array(0) {
}
array(0) {
}
array(0) {
}
*** positive offset, variable length ***
array(0) {
}
array(0) {
}
array(0) {
}
*** negative offset, variable length ***
array(0) {
}
array(0) {
}
array(0) {
}

*** Iteration 2 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
}
array(6) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
  [3]=>
  int(4)
  [4]=>
  int(5)
  [5]=>
  int(6)
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  int(2)
  [1]=>
  int(3)
  [2]=>
  int(4)
}
array(5) {
  [0]=>
  int(2)
  [1]=>
  int(3)
  [2]=>
  int(4)
  [3]=>
  int(5)
  [4]=>
  int(6)
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  int(8)
  [1]=>
  int(9)
}
array(0) {
}

*** Iteration 3 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "One"
  [1]=>
  string(3) "Two"
  [2]=>
  string(5) "Three"
}
array(2) {
  [0]=>
  string(3) "One"
  [1]=>
  string(3) "Two"
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "Two"
  [1]=>
  string(5) "Three"
  [2]=>
  string(4) "Four"
}
array(1) {
  [0]=>
  string(3) "Two"
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  string(4) "Four"
  [1]=>
  string(4) "Five"
}
array(0) {
}

*** Iteration 4 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  int(6)
  [1]=>
  string(3) "six"
  [2]=>
  int(7)
}
array(5) {
  [0]=>
  int(6)
  [1]=>
  string(3) "six"
  [2]=>
  int(7)
  [3]=>
  string(5) "seven"
  [4]=>
  int(8)
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "six"
  [1]=>
  int(7)
  [2]=>
  string(5) "seven"
}
array(4) {
  [0]=>
  string(3) "six"
  [1]=>
  int(7)
  [2]=>
  string(5) "seven"
  [3]=>
  int(8)
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  int(9)
  [1]=>
  string(4) "nine"
}
array(0) {
}

*** Iteration 5 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  ["a"]=>
  string(3) "aaa"
  ["A"]=>
  string(3) "AAA"
  ["c"]=>
  string(3) "ccc"
}
array(2) {
  ["a"]=>
  string(3) "aaa"
  ["A"]=>
  string(3) "AAA"
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  ["A"]=>
  string(3) "AAA"
  ["c"]=>
  string(3) "ccc"
  ["d"]=>
  string(3) "ddd"
}
array(1) {
  ["A"]=>
  string(3) "AAA"
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  ["d"]=>
  string(3) "ddd"
  ["e"]=>
  string(3) "eee"
}
array(0) {
}

*** Iteration 6 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
  [2]=>
  string(5) "three"
}
array(2) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "two"
  [1]=>
  string(5) "three"
  [2]=>
  string(4) "four"
}
array(1) {
  [0]=>
  string(3) "two"
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  string(4) "four"
  [1]=>
  string(4) "five"
}
array(0) {
}

*** Iteration 7 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
  [2]=>
  int(7)
}
array(2) {
  [0]=>
  string(3) "one"
  [1]=>
  string(3) "two"
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "two"
  [1]=>
  int(7)
  [2]=>
  string(4) "four"
}
array(1) {
  [0]=>
  string(3) "two"
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  string(4) "four"
  [1]=>
  string(4) "five"
}
array(0) {
}

*** Iteration 8 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  ["f"]=>
  string(3) "fff"
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
}
array(7) {
  ["f"]=>
  string(3) "fff"
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
  [""]=>
  string(5) "blank"
  [2]=>
  string(5) "float"
  ["F"]=>
  string(3) "FFF"
  ["blank"]=>
  string(0) ""
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
  [""]=>
  string(5) "blank"
}
array(6) {
  [0]=>
  string(3) "one"
  [1]=>
  int(6)
  [""]=>
  string(5) "blank"
  [2]=>
  string(5) "float"
  ["F"]=>
  string(3) "FFF"
  ["blank"]=>
  string(0) ""
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  string(4) "Five"
  [1]=>
  float(8.6)
}
array(0) {
}

*** Iteration 9 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  int(12)
  [1]=>
  string(4) "name"
  [2]=>
  string(3) "age"
}
array(1) {
  [0]=>
  int(12)
}
*** positive offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  string(4) "name"
  [1]=>
  string(3) "age"
  [2]=>
  string(2) "45"
}
array(0) {
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  string(3) "age"
  [1]=>
  string(2) "45"
}
array(0) {
}

*** Iteration 10 ***
*** zero offset, variable length ***
array(0) {
}
array(3) {
  [0]=>
  array(3) {
    [0]=>
    string(3) "oNe"
    [1]=>
    string(3) "tWo"
    [2]=>
    int(4)
  }
  [1]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [2]=>
  array(0) {
  }
}
array(0) {
}
*** positive offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [1]=>
  array(0) {
  }
}
array(0) {
}
*** negative offset, variable length ***
array(0) {
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(10)
    [1]=>
    int(20)
    [2]=>
    int(30)
    [3]=>
    int(40)
    [4]=>
    int(50)
  }
  [1]=>
  array(0) {
  }
}
array(0) {
}
