/*
 * Decompiled with CFR 0.152.
 */
package com.merant.datadirect.jdbc.sqlserver;

import com.merant.datadirect.util.UtilByteOrderedDataReader;
import com.merant.datadirect.util.UtilException;
import java.io.InputStream;

public class SQLServerLongDataStream
extends InputStream {
    private static String footprint = "$Revision:   1.4  $";
    private UtilByteOrderedDataReader reader;
    private long totalDataSize;
    private long numBytesReturned;
    boolean isUCS2Stream;
    int savedByteValue;

    public SQLServerLongDataStream(UtilByteOrderedDataReader utilByteOrderedDataReader, boolean bl, long l) {
        this.totalDataSize = l;
        this.reader = utilByteOrderedDataReader;
        this.numBytesReturned = 0L;
        this.isUCS2Stream = bl;
        this.savedByteValue = -1;
    }

    public void close() {
        try {
            if (this.numBytesReturned < this.totalDataSize) {
                this.reader.readAndDiscardBytes((int)(this.totalDataSize - this.numBytesReturned));
            }
            this.numBytesReturned = this.totalDataSize;
        }
        catch (UtilException utilException) {}
    }

    public int read() {
        if (this.numBytesReturned >= this.totalDataSize) {
            return -1;
        }
        try {
            int n;
            if (this.isUCS2Stream) {
                if (this.savedByteValue == -1) {
                    this.savedByteValue = this.reader.readUnsignedInt8();
                    n = this.reader.readUnsignedInt8();
                } else {
                    n = this.savedByteValue;
                    this.savedByteValue = -1;
                }
            } else {
                n = this.reader.readUnsignedInt8();
            }
            ++this.numBytesReturned;
            return n;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.numBytesReturned >= this.totalDataSize) {
            return -1;
        }
        try {
            if ((long)n2 > this.totalDataSize - this.numBytesReturned) {
                n2 = (int)this.totalDataSize - (int)this.numBytesReturned;
            }
            if (this.isUCS2Stream) {
                int n3 = 0;
                while (n3 < n2) {
                    byte by = (byte)this.read();
                    if (by != -1) {
                        byArray[n + n3] = by;
                    }
                    ++n3;
                }
            } else {
                this.reader.readBytes(byArray, n, n2);
            }
            this.numBytesReturned += (long)n2;
            return n2;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }
}

