/*
 * Decompiled with CFR 0.152.
 */
package com.merant.datadirect.jdbc.sqlserver.tds;

import com.merant.datadirect.jdbc.base.BaseExceptions;
import com.merant.datadirect.jdbc.sqlserver.SQLServerDepacketizingDataProvider;
import com.merant.datadirect.jdbc.sqlserver.SQLServerPacketizingDataConsumer;
import com.merant.datadirect.util.UtilBufferedDataConsumer;
import com.merant.datadirect.util.UtilBufferedDataProvider;
import com.merant.datadirect.util.UtilDataConsumer;
import com.merant.datadirect.util.UtilDataProvider;
import com.merant.datadirect.util.UtilDebug;
import com.merant.datadirect.util.UtilSocketDataConsumer;
import com.merant.datadirect.util.UtilSocketDataProvider;
import com.merant.datadirect.util.UtilTransliterator;
import com.merant.datadirect.util.UtilTransliteratorForUCS2;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Vector;

public class TDSConnection {
    private static String footprint = "$Revision:   1.16  $";
    private Socket socket;
    private UtilSocketDataConsumer socketConsumer;
    private UtilBufferedDataConsumer bufferedConsumer;
    private SQLServerPacketizingDataConsumer packetizer;
    public UtilSocketDataProvider socketProvider;
    private UtilBufferedDataProvider bufferedProvider;
    private SQLServerDepacketizingDataProvider depacketizer;
    BaseExceptions exceptions;
    byte[] sqlCollation;
    int tdsVersion;
    public UtilTransliteratorForUCS2 unicodeTransliterator = null;
    public UtilTransliterator nonUnicodeTransliterator = null;
    Vector transliterators = null;
    public int numOutstandingCancelRequests;
    public static final int TDS_UNDEFINED = 0;
    public static final int TDS_07000000 = 1;
    public static final int TDS_07010000 = 2;

    public TDSConnection(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        this.exceptions = baseExceptions;
        try {
            this.socket = new Socket(string, Integer.parseInt(string2));
        }
        catch (Exception exception) {
            SQLException sQLException = this.exceptions.getException(exception);
            throw this.exceptions.getException(sQLException, 11002, "08001");
        }
        this.unicodeTransliterator = (UtilTransliteratorForUCS2)this.getTransliteratorForCodePage("UCS2");
        this.unicodeTransliterator.setToLittleEndian();
        this.socketConsumer = new UtilSocketDataConsumer(this.socket);
        this.bufferedConsumer = new UtilBufferedDataConsumer((UtilDataConsumer)this.socketConsumer);
        this.packetizer = new SQLServerPacketizingDataConsumer(this.bufferedConsumer);
        this.socketProvider = new UtilSocketDataProvider(this.socket);
        this.bufferedProvider = new UtilBufferedDataProvider((UtilDataProvider)this.socketProvider);
        this.depacketizer = new SQLServerDepacketizingDataProvider((UtilDataProvider)this.bufferedProvider);
        this.tdsVersion = 0;
        this.numOutstandingCancelRequests = 0;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    public SQLServerDepacketizingDataProvider getDepacketizer() {
        return this.depacketizer;
    }

    public SQLServerPacketizingDataConsumer getPacketizer() {
        return this.packetizer;
    }

    public byte[] getSQLCollation() {
        return this.sqlCollation;
    }

    public int getTDSVersion() {
        return this.tdsVersion;
    }

    public UtilTransliterator getTransliteratorForCodePage(String string) {
        Object object;
        if (this.transliterators == null) {
            this.transliterators = new Vector(10);
        }
        int n = 0;
        while (n < this.transliterators.size()) {
            object = (TransliteratorForLCID)this.transliterators.elementAt(n);
            if (string.compareTo(object.codePage) == 0) {
                return object.transliterator;
            }
            ++n;
        }
        object = null;
        try {
            object = UtilTransliterator.GetNewTransliterator((String)string);
        }
        catch (Exception exception) {
            UtilDebug.assert((String)("Unable to create transliterator for code page " + string), (boolean)false);
        }
        if (object != null) {
            TransliteratorForLCID transliteratorForLCID = new TransliteratorForLCID();
            transliteratorForLCID.codePage = string;
            transliteratorForLCID.transliterator = object;
            this.transliterators.addElement(transliteratorForLCID);
        }
        return object;
    }

    String mapCollationToCodePage(byte[] byArray) {
        int n = (byArray[2] & 0xF) << 12 | byArray[1] << 8 | byArray[0];
        String string = null;
        switch (n) {
            case 1058: 
            case 1071: {
                string = "1251";
                break;
            }
            case 1027: 
            case 1031: 
            case 1033: 
            case 1034: 
            case 1036: 
            case 1039: 
            case 1040: 
            case 1043: 
            case 1044: 
            case 1046: 
            case 1053: 
            case 2057: 
            case 3082: 
            case 66567: 
            case 66615: {
                string = "1252";
                break;
            }
            case 2052: {
                string = "936";
                break;
            }
            case 1028: 
            case 133124: 
            case 197636: {
                string = "950";
                break;
            }
            case 1029: 
            case 1038: 
            case 1045: 
            case 1048: 
            case 1050: 
            case 1051: 
            case 1060: 
            case 66574: {
                string = "1250";
                break;
            }
            case 1061: 
            case 1062: 
            case 1063: {
                string = "1257";
                break;
            }
            case 1041: 
            case 66577: {
                string = "932";
                break;
            }
            case 1042: 
            case 66578: {
                string = "949";
                break;
            }
            case 1054: {
                string = "874";
                break;
            }
            case 1066: {
                string = "1258";
                break;
            }
            default: {
                UtilDebug.assert((String)("Unexpected LCID: " + n), (boolean)false);
            }
        }
        return string;
    }

    public void setMessageType(int n) {
        this.packetizer.setMessageType(n);
    }

    public void setPacketSize(int n) {
        this.packetizer.setMessageType(n);
    }

    public void setSQLCollation(byte[] byArray) {
        this.sqlCollation = byArray;
        try {
            this.nonUnicodeTransliterator = this.getTransliteratorForCodePage(this.mapCollationToCodePage(byArray));
        }
        catch (Exception exception) {
            UtilDebug.assert((String)"Unable to create transliterator for code page Cp1251", (boolean)false);
        }
    }

    public void setTDSVersion(int n) {
        if (n == 0x7000000) {
            this.tdsVersion = 1;
        } else if (n == 0x7010000) {
            this.tdsVersion = 2;
        } else {
            UtilDebug.assert((String)"The server is using an unknown TDS version.", (boolean)false);
        }
    }

    private class TransliteratorForLCID {
        String codePage;
        UtilTransliterator transliterator;

        TransliteratorForLCID() {
        }
    }
}

