/*
 * Decompiled with CFR 0.152.
 */
package no.rwr.engine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import no.rwr.engine.GUIStyle;
import no.rwr.engine.Question;
import no.rwr.engine.SectionInfo;
import no.rwr.engine.Session;

public class SummaryGUI {
    Session session;
    JPanel gui = new JPanel();
    JComponent body;
    Box commands = new Box(0);

    SummaryGUI(ActionListener actionListener) {
        JButton jButton = new JButton("Close");
        jButton.addActionListener(actionListener);
        this.commands.add(jButton);
        this.gui.setBorder(GUIStyle.paddingBorder);
        this.gui.setLayout(new BorderLayout());
        this.gui.add((Component)this.commands, "South");
        jButton.addActionListener(actionListener);
    }

    public Container getPane() {
        return this.gui;
    }

    public void setSession(Session session) {
        Object object;
        Object object2;
        String string;
        if (this.body != null) {
            this.gui.remove(this.body);
        }
        this.session = session;
        int n = this.session.getQuestionCount();
        int n2 = 0;
        HashMap<String, SectionInfo> hashMap = new HashMap<String, SectionInfo>();
        int n3 = 0;
        while (n3 < n) {
            Question question = this.session.getQuestion(n3);
            string = question.getSection();
            object2 = (SectionInfo)hashMap.get(string);
            if (object2 == null) {
                object2 = new SectionInfo();
                ((SectionInfo)object2).name = string;
                hashMap.put(string, (SectionInfo)object2);
            }
            ++((SectionInfo)object2).total;
            if (question.isCorrect()) {
                ++n2;
                ++((SectionInfo)object2).correct;
            }
            ++n3;
        }
        int n4 = (int)Math.round(100.0 * (double)n2 / (double)n);
        string = n4 > 70 ? "Passed" : "Failed";
        object2 = "<title>Summary</title><h1>" + string + "</h1>" + "<hr>" + "<p>Final score: " + n4 + "% (" + n2 + " of " + n + " correct)</p>" + "<hr><table>";
        TreeSet treeSet = new TreeSet(hashMap.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            SectionInfo sectionInfo = (SectionInfo)hashMap.get(object);
            int n5 = (int)Math.round(100.0 * (double)sectionInfo.correct / (double)sectionInfo.total);
            String string2 = sectionInfo.total == 0 ? "none" : String.valueOf(n5) + "%";
            object2 = String.valueOf(object2) + "<tr><td>Section: " + sectionInfo.name + "</td>" + "<td>" + string2 + "</td></tr>";
        }
        object2 = String.valueOf(object2) + "</table>";
        object = new JEditorPane("text/html", (String)object2);
        ((JTextComponent)object).setEditable(false);
        this.body = new JScrollPane((Component)object);
        this.gui.add((Component)this.body, "Center");
    }
}

