package ca.athabascau.exam.request.update;

import org.apache.log4j.Logger;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Calendar;


/**
 * Service implementation for Exam Request Update web service.
 */
public class ExamRequestUpdateService
{

    /**
     * Logging mechanism.
     */
    private static final Logger logger = Logger.getLogger(
        ExamRequestUpdateService.class.getName());

    /**
     * Update exam request in Banner.
     *
     * @param examRequestID     ID of exam request for matching
     * @param studentID         ID of student
     * @param examWriteDate     Write date for exam
     * @param invigilatorID     ID of invigilator (may have changed since
     *                          initial request) if correction by ESU staff in
     *                          CMD
     * @param inventoryID       Typically, selected by CMD automatically
     * @param requestStatus     A status code
     * @param requestStatusDate Date of accompanying status
     * @param userIDWhoUpdated  ID of user who made update
     *
     * @return UpdateResponse that encapsulates response
     *
     * @throws RemoteException
     */
    // TODO: Properly specify required/optional fields
    public boolean update(final long examRequestID
        , final String studentID
        , final Calendar examWriteDate
        , final String invigilatorID
        , final long inventoryID
        , final String requestStatus
        , final Calendar requestStatusDate
        , final String userIDWhoUpdated) throws RemoteException, SQLException
    {
        return false;
    }
}
