/**
 * Test for Texture Bug.
 * Daniel del Rio. 20 may 2000
 * e-mail: dani_rio@teleline.es
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.image.TextureLoader;

public class TestTextureBug {
	
	private Canvas3D canvas;
	private Texture2D woodTexture;
	private Texture2D earthTexture;
	
	private JComboBox boxComboBox;
	private JComboBox sphereComboBox;
		
	private Primitive box;
	private Primitive sphere;
	
	
	public TestTextureBug() {
		JFrame frame = new JFrame("Test Texture Bug");
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);			
			}		
		});
		
		createTextures();
		createScene();			
		
		frame.setContentPane(constructGUI());
		frame.setSize(new Dimension(400, 350)); 
		frame.setVisible(true);
	}
	
	private void createTextures() {
		JPanel observer = new JPanel();
		
		TextureLoader loader = new TextureLoader("earth.jpg", observer);
		ImageComponent2D image = loader.getImage();
		earthTexture = getTexture(image);
		
		loader = new TextureLoader("wood.jpg", observer);
		image = loader.getImage();
		woodTexture = getTexture(image);
	}
	
	private Texture2D getTexture(ImageComponent image) {
		Texture2D t = new Texture2D(Texture.BASE_LEVEL, Texture.RGB, 
				image.getWidth(), image.getHeight());
		t.setImage(0, image);
		return t;
	} 
	
	private void createScene() {
		Transform3D trans = new Transform3D();
		int primitiveFlags = Primitive.ENABLE_APPEARANCE_MODIFY |
				Primitive.GENERATE_NORMALS | Primitive.GENERATE_TEXTURE_COORDS;
				
		Material material = new Material();
		TextureAttributes textureAtt = new TextureAttributes();
		textureAtt.setTextureMode(TextureAttributes.BLEND);
		
		canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		SimpleUniverse su = new SimpleUniverse(canvas);
		su.getViewingPlatform().setNominalViewingTransform();
		
		BranchGroup root = new BranchGroup();
		
		// Box
		TransformGroup tgBox = new TransformGroup();
		trans.set(new Vector3f(-0.5f, 0.0f, 0.0f));
		tgBox.setTransform(trans);		
		Appearance app = createAppearance();
		app.setTexture(woodTexture);
		app.setTextureAttributes(textureAtt);
		app.setMaterial(material);
		//box = new com.sun.j3d.utils.geometry.Box(0.5f, 0.5f, 0.5f, primitiveFlags, app);
		// Bug in Box. xside, yside, zside are xdim * 2, ydim * 2, zdim * 2
		box = new com.sun.j3d.utils.geometry.Box(0.25f, 0.25f, 0.25f, primitiveFlags, app);
		tgBox.addChild(box);	
		
		// Sphere		
		TransformGroup tgSphere = new TransformGroup();
		trans.set(new Vector3f(0.5f, 0.0f, 0.0f));
		tgSphere.setTransform(trans);
		app = createAppearance();
		app.setTexture(earthTexture);
		app.setTextureAttributes(textureAtt);
		app.setMaterial(material);
		sphere = new Sphere(0.25f, primitiveFlags, app);		
		tgSphere.addChild(sphere);
		
		// ligth
		Light dl = new DirectionalLight();
		dl.setInfluencingBounds(new BoundingSphere(new Point3d(), 10.0));
		
		root.addChild(tgBox);
		root.addChild(tgSphere);		
		root.addChild(dl);
		
		su.addBranchGraph(root);	
	}
	
	private Appearance createAppearance() {
		Appearance app = new Appearance();
		app.setCapability(Appearance.ALLOW_TEXTURE_READ);
		app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
		return app;
	}
	
	private JPanel constructGUI() {		
		TextureListener listener = new TextureListener();
		String[] names = {"Earth", "Wood"};
		
		boxComboBox = new JComboBox(names);	
		boxComboBox.setSelectedIndex(1);
		boxComboBox.addItemListener(listener);
		
		sphereComboBox = new JComboBox(names);
		sphereComboBox.addItemListener(listener);		
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.add(new JLabel("Box Texture: "));
		bottomPanel.add(boxComboBox);
		bottomPanel.add(new JLabel("Sphere Texture: "));
		bottomPanel.add(sphereComboBox);
		
		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		p.add(canvas, BorderLayout.CENTER);
		p.add(bottomPanel, BorderLayout.SOUTH);
		p.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
		return p;			
	}
	
	private class TextureListener implements ItemListener {
		public void itemStateChanged(ItemEvent e) {
			Texture2D texture;
			Primitive primitive;
			
			if (e.getStateChange() == ItemEvent.SELECTED) {
				JComboBox cb = (JComboBox) e.getSource();
				String s = (String) e.getItem();				
				
				texture = s == "Earth" ? earthTexture : woodTexture;
				primitive = cb == boxComboBox ? box : sphere;
				
				Appearance app = primitive.getAppearance();
				app.setTexture(texture);				
			}			
		}
	}	
	
	
	public static void main(String[] args) {
		TestTextureBug test = new TestTextureBug();
	}
	
}