/*
 *      @(#)PickTestExt.java 1.2 99/04/29 12:04:24
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

//import com.sun.j3d.utils.behaviors.picking.*;
import pickingExt.*;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.Component;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.Point;
import javax.swing.*;
import javax.swing.border.BevelBorder;

/**
 * PickTestExt shows how to use the pickingExt utilities on various 
 * GeometryArray subclasses and Morph object.
 * Type of Geometry      : CompressedGeometry ( GullCG.java )
 *                         IndexedQuadArray ( CubeIQA.java )
 *                         TriangleArray ( TetrahedronTA.java )
 *                         IndexedTriangleArray ( TetrahedronITA.java )
 *                         TriangleFanArray ( OctahedronTFA.java )
 *                         IndexedTriangleFanArray ( OctahedronITA.java )
 *                         TriangleStripArray ( IcosahedronTFA.java )
 *                         IndexedTriangleStripArray ( IcosahedronITA.java )
 *			   PointArray( TetrahedronPA.java )
 *			   LineArray( TetrahedronLA.java )
 *			   IndexLineArray( TetrahedronILA.java )
 *			   LineStripArray( TetrahedronLSA.java )
 *			   IndexLineStripArray( TetrahedronILSA.java )
 *
 * Morph Object uses :     QuadArray ( ColorCube.java, ColorPyramidDown.java, 
 *				and ColorPyramidUp.java ).
 */

public class PickTestExt extends Applet implements ActionListener {
  
  private QuadArray geomMorph[] = new QuadArray[3];
  private Morph morph;

  private PickRotateBehavior behavior1;
  private PickZoomBehavior   behavior2;
  private PickTranslateBehavior behavior3;

  private Point[] aperture8;
  private Point[] aperture16;


  public BranchGroup createSceneGraph(Canvas3D canvas)
  {
    // Create the root of the branch graph
    BranchGroup objRoot = new BranchGroup();

    // Create a Transformgroup to scale all objects so they
    // appear in the scene.
    TransformGroup objScale = new TransformGroup();
    Transform3D t3d = new Transform3D();
    t3d.setScale(1.0);
    objScale.setTransform(t3d);
    objRoot.addChild(objScale);
    
    // Create a bunch of objects with a behavior and add them
    // into the scene graph.
    
    int row, col;
    int numRows = 4, numCols = 4;
    
    for (int i = 0; i < numRows; i++) {
      double ypos = (double)(i - numRows/2) * 0.45 + 0.25;
      for (int j = 0; j < numCols; j++) {
	double xpos = (double)(j - numCols/2) * 0.45 + 0.25;
	objScale.addChild(createObject(i * numCols + j, 0.1,  xpos, ypos));
      }
    }

    BoundingSphere bounds =
      new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

    // Add a light.
    Color3f lColor = new Color3f(1.0f, 1.0f, 1.0f) ;
    Vector3f lDir  = new Vector3f(0.0f, 0.0f, -1.0f) ;

    DirectionalLight lgt = new DirectionalLight(lColor, lDir) ;
    lgt.setInfluencingBounds(bounds) ;
    objRoot.addChild(lgt) ;


    // Now create the Alpha object that controls the speed of the
    // morphing operation.
    Alpha morphAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
				 Alpha.DECREASING_ENABLE,
				 0, 0,
				 4000, 1000, 500,
				 4000, 1000, 500);
      
    // Finally, create the morphing behavior
    //MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);  
    //mBeh.setSchedulingBounds(bounds);
    //objRoot.addChild(mBeh);

        
    behavior1 = new PickRotateBehavior(objRoot, canvas, bounds);
    objRoot.addChild(behavior1);

    behavior2 = new PickZoomBehavior(objRoot, canvas, bounds);
    objRoot.addChild(behavior2);

    behavior3 = new PickTranslateBehavior(objRoot, canvas, bounds);
    objRoot.addChild(behavior3);

    // Let Java 3D perform optimizations on this scene graph.
    objRoot.compile();
 
    return objRoot;
  }
  

  private Group createObject(int index, double scale, double xpos, double ypos){
    
    Shape3D shape = null;
    Geometry geom = null;
     
    // Create a transform group node to scale and position the object.
    Transform3D t = new Transform3D();
    t.set(scale, new Vector3d(xpos, ypos, 0.0));
    TransformGroup objTrans = new TransformGroup(t);
    objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    objTrans.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
    
    // Create a second transform group node and initialize it to the
    // identity.  Enable the TRANSFORM_WRITE capability so that
    // our behavior code can modify it at runtime.
    TransformGroup spinTg = new TransformGroup();
    spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    spinTg.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
 
    Appearance appearance = new Appearance();

    switch(index) {
    case 0:
      geom = new GullCG();
      break;
    case 1:
      geom = new TetrahedronTA();
      break;
    case 2:
      geom = new OctahedronTFA();  
      break;
    case 3:
      geom = new IcosahedronTSA();    
      break;
    case 4:
      geom = new CubeIQA();   
      break;
    case 5:
      geom = new TetrahedronITA();  
      break;
    case 6:
      geom = new OctahedronITFA();  
      break;
    case 7:
      geom = new IcosahedronITSA();  
      break;
    case 8:
      geomMorph[0] = new ColorPyramidUp();
      geomMorph[1] = new ColorCube();
      geomMorph[2] = new ColorPyramidDown();
      break;
    case 9:
      geom = new TetrahedronLA();
      break;
    case 10:
      geom = new TetrahedronILA();
      break;
    case 11:
      geom = new TetrahedronLSA();
      break;
    case 12:
      geom = new TetrahedronILSA();
      break;
    case 13:
      geom = new TetrahedronPA();
      break;
    case 14:
      geom = new TetrahedronIPA();
      break;
    // TODO: other geo types, Text3D?
    case 15:
      geom = new TetrahedronTA();
      break;
    }

    Material m = new Material() ;
        
    if(index == 8) {
	// Geometry picking require this to be set.
	geomMorph[0].setCapability(Geometry.ALLOW_INTERSECT);
	geomMorph[1].setCapability(Geometry.ALLOW_INTERSECT);
	geomMorph[2].setCapability(Geometry.ALLOW_INTERSECT);

	m.setLightingEnable(false) ;
	appearance.setMaterial(m) ;
	morph = new Morph((GeometryArray[]) geomMorph, appearance);
	morph.setCapability(Morph.ALLOW_WEIGHTS_READ);
	morph.setCapability(Morph.ALLOW_WEIGHTS_WRITE);
	spinTg.addChild(morph); 
    } else {
	// Geometry picking require this to be set.
	geom.setCapability(Geometry.ALLOW_INTERSECT);

	if (index == 0)
	    m.setLightingEnable(true) ;
	else
	    m.setLightingEnable(false) ;
	appearance.setMaterial(m) ;

	if ((index == 13) || (index == 14)) {
	    PointAttributes pa = new PointAttributes();
	    pa.setPointSize(4.0f);
	    appearance.setPointAttributes(pa);
	}

	shape = new Shape3D(geom,appearance);
	shape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
	shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
	shape.setCapability(Shape3D.ENABLE_PICK_REPORTING);
	spinTg.addChild(shape);
    } 
     
    // add it to the scene graph. 
    objTrans.addChild(spinTg);    

    return objTrans;
  }

  private void setPickMode(int mode) {
      behavior1.setPickMode(mode);
      behavior2.setPickMode(mode);
      behavior3.setPickMode(mode);
  }

  private void setPickShapeMode(int mode) {
      behavior1.setPickShapeMode(mode);
      behavior2.setPickShapeMode(mode);
      behavior3.setPickShapeMode(mode);
  }

  private void setPickAperture(Point[] aperture) {
      behavior1.setPickAperture(aperture);
      behavior2.setPickAperture(aperture);
      behavior3.setPickAperture(aperture);
  }

  // GUI stuff

  String pickModeString = new String("Pick Mode");
  String boundsString = new String("USE_BOUNDS");
  String geometryString = new String("USE_GEOMETRY");
  String shapeModeString = new String("Pick Shape Mode");
  String shapeRayString = new String("SHAPE_RAY");
  String shapeApertureString = new String("SHAPE_APERTURE");
  String shapeRayApertureString = new String("SHAPE_RAY_APERTURE");
  String apertureSizeString = new String("Pick Aperture Size");
  String apertureSize8String = new String("8");
  String apertureSize16String = new String("16");

  private void addRadioButton(JPanel panel, ButtonGroup bg, String ownerName,
		  String buttonName, boolean selected) {
      JRadioButton	item;
      item = new JRadioButton(buttonName);
      item.setName(ownerName);
      item.addActionListener(this);
      if (selected) {
	  item.setSelected(true);
      }
      panel.add(item);
      bg.add(item);
  }

  private void setupGUI(JPanel panel) {
      ButtonGroup 	bg;

      panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
      panel.setBorder(new BevelBorder(BevelBorder.RAISED));

      panel.add(new JLabel(pickModeString));
      bg = new ButtonGroup();
      addRadioButton(panel, bg, pickModeString, boundsString, true);
      addRadioButton(panel, bg, pickModeString, geometryString, false);

      panel.add(new JLabel(shapeModeString));
      bg = new ButtonGroup();
      addRadioButton(panel, bg, shapeModeString, shapeRayString, true);
      addRadioButton(panel, bg, shapeModeString, shapeApertureString, false);
      addRadioButton(panel, bg, shapeModeString, shapeRayApertureString, false);

      panel.add(new JLabel(apertureSizeString));
      bg = new ButtonGroup();
      addRadioButton(panel, bg, apertureSizeString, apertureSize8String, true);
      addRadioButton(panel, bg, apertureSizeString, apertureSize16String,false);

  }

  public void actionPerformed(ActionEvent e) {
      String name = ((Component)e.getSource()).getName();
      String value = e.getActionCommand();
      //System.out.println("action: name = " + name + " value = " + value);
      if (name == pickModeString) {
	 if (value == boundsString) {
	     setPickMode(PickObject.USE_BOUNDS);
	 } else if (value == geometryString) {
	     setPickMode(PickObject.USE_GEOMETRY);
	 } else {
	     System.out.println("Unknown pick mode: " + value); 
	 }
      } else if (name == shapeModeString) {
	 if (value == shapeRayString) {
	     setPickShapeMode(PickObject.SHAPE_RAY);
	 } else if (value == shapeApertureString) {
	     setPickShapeMode(PickObject.SHAPE_APERTURE);
	 } else if (value == shapeRayApertureString) {
	     setPickShapeMode(PickObject.SHAPE_RAY_APERTURE);
	 } else {
	     System.out.println("Unknown pick shape mode: " + value); 
	 }
      } else if (name == apertureSizeString) {
	 if (value == apertureSize8String) {
	     setPickAperture(aperture8);
	 } else if (value == apertureSize16String) {
	     setPickAperture(aperture16);
	 } else {
	     System.out.println("Unknown aperture size: " + value); 
	 }
      } else {
	 System.out.println("Unknown action name: " + name); 
      }
  }
  
  public PickTestExt (){
    // set up the 8 pixel pick aperture
    aperture8 = new Point[4];
    aperture8[0] = new Point(-4, -4);
    aperture8[1] = new Point(4, -4);
    aperture8[2] = new Point(4, 4);
    aperture8[3] = new Point(-4, 4);

    // set up the 16 pixel pick aperture
    aperture16 = new Point[4];
    aperture16[0] = new Point(-8, -8);
    aperture16[1] = new Point(8, -8);
    aperture16[2] = new Point(8, 8);
    aperture16[3] = new Point(-8, 8);

    setLayout(new BorderLayout());
    Canvas3D c = new Canvas3D(null);
    add("Center", c);

    JPanel guiPanel = new JPanel();
    setupGUI(guiPanel);
    add(guiPanel, BorderLayout.EAST);
    
    // Create a scene and attach it to the virtual universe
    BranchGroup scene = createSceneGraph(c);
    SimpleUniverse u = new SimpleUniverse(c);

    // This will move the ViewPlatform back a bit so the
    // objects in the scene can be viewed.
    u.getViewingPlatform().setNominalViewingTransform();

    u.addBranchGraph(scene);
  }
  
  
  public static void main(String argv[])
  {
    
    BranchGroup group;
    
    new MainFrame(new PickTestExt(), 750, 550);
  }
}

