/*
 *	@(#)cgview.java 1.2 99/05/23 22:25:03
 *
 * Copyright (c) 1996-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import com.sun.j3d.utils.compression.* ;
import com.sun.j3d.utils.behaviors.mouse.* ;
import com.sun.j3d.utils.applet.MainFrame ;
import com.sun.j3d.utils.universe.* ;
import javax.media.j3d.* ;
import javax.vecmath.* ;
import java.applet.Applet ;
import java.awt.BorderLayout ;
import java.awt.event.* ;
import java.io.* ;

public class cgview extends Applet {
    private static final boolean cullFront = false ;
    private static final boolean cullNone  = false ;

    public BranchGroup createSceneGraph(CompressedGeometry cg) {
	// Create the root of the branch graph
	BranchGroup objRoot = new BranchGroup() ;

        // Create a Transformgroup to scale all objects so they
        // appear in the scene.
        TransformGroup objScale = new TransformGroup() ;
        Transform3D t3d = new Transform3D() ;
        t3d.setScale(0.7) ;
        objScale.setTransform(t3d) ;
        objRoot.addChild(objScale) ;

	// Create the transform group node and initialize it to the
	// identity.  Enable the TRANSFORM_WRITE capability so that
	// our behavior code can modify it at runtime.  Add it to the
	// root of the subgraph.
	TransformGroup objTrans = new TransformGroup() ;
	objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE) ;
	objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ) ;
	objScale.addChild(objTrans) ;

	// Add compressed geometry to the scene graph.
	CompressedGeometryHeader hdr = new CompressedGeometryHeader() ;
	cg.getCompressedGeometryHeader(hdr) ;

	Material m = new Material() ;
	if ((hdr.bufferDataPresent &
	     CompressedGeometryHeader.NORMAL_IN_BUFFER) == 0)
	    m.setLightingEnable(false) ;
	else
	    m.setLightingEnable(true) ;

	Appearance a = new Appearance() ;
	a.setMaterial(m) ;

	if (cullFront || cullNone) {
	    PolygonAttributes pa = new PolygonAttributes() ;

	    if (cullFront)
		pa.setCullFace(pa.CULL_FRONT) ;
	    else
		pa.setCullFace(pa.CULL_NONE) ;
		
	    a.setPolygonAttributes(pa) ;
	}

	objTrans.addChild(new Shape3D(cg, a)) ;

	// Create mouse behavior scheduling bounds.
	BoundingSphere bounds =
	    new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0) ;

	// Create the rotate behavior node
	MouseRotate behavior = new MouseRotate() ;
	behavior.setTransformGroup(objTrans) ;
	objTrans.addChild(behavior) ;
	behavior.setSchedulingBounds(bounds) ;

	// Create the zoom behavior node
	MouseZoom behavior2 = new MouseZoom() ;
	behavior2.setTransformGroup(objTrans) ;
	objTrans.addChild(behavior2) ;
	behavior2.setSchedulingBounds(bounds) ;

	// Create the translate behavior node
	MouseTranslate behavior3 = new MouseTranslate() ;
	behavior3.setTransformGroup(objTrans) ;
	objTrans.addChild(behavior3) ;
	behavior3.setSchedulingBounds(bounds) ;

        // Set up the background
        Color3f bgColor = new Color3f(0.0f, 0.0f, 0.0f) ;
        Background bgNode = new Background(bgColor) ;
        bgNode.setApplicationBounds(bounds) ;
        objRoot.addChild(bgNode) ;

        // Set up the ambient light
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f) ;
        AmbientLight ambientLightNode = new AmbientLight(ambientColor) ;
        ambientLightNode.setInfluencingBounds(bounds) ;
        objRoot.addChild(ambientLightNode) ;

        // Set up the directional lights
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f) ;
        Vector3f light1Direction  = new Vector3f(4.0f, -7.0f, -12.0f) ;
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f) ;
        Vector3f light2Direction  = new Vector3f(-6.0f, -2.0f, -1.0f) ;

        DirectionalLight light1
            = new DirectionalLight(light1Color, light1Direction) ;
        light1.setInfluencingBounds(bounds) ;
        objRoot.addChild(light1) ;

        DirectionalLight light2
            = new DirectionalLight(light2Color, light2Direction) ;
        light2.setInfluencingBounds(bounds) ;
        objRoot.addChild(light2) ;

	return objRoot ;
    }

    private void usage() {
	System.out.println("Usage: cgview <.cg file> <object index>")  ;
	System.exit(0)  ;
    }

    public cgview(String args[]) {
        if (args.length < 1)
	    usage() ;

	int index ;
	if (args.length < 2)
	    index = 0 ;
	else
	    index = Integer.parseInt(args[1]) ;

	String filename = args[0] ;
	if (filename == null)
	    usage() ;

	// Read the compressed geometry.
	CompressedGeometry cg = null ;
	try {
	    CompressedGeometryFile cgf ;
	    cgf = new CompressedGeometryFile(filename, false) ;

	    if (cgf.getObjectCount() == 0) {
		System.out.println("no objects were found in " + filename) ;
		System.exit(0) ;
	    }

	    cg = cgf.read(index) ;
	    cgf.close() ;

	} catch (IOException e) {
	    System.out.println(e) ;
	    System.exit(0) ;
	}

	setLayout(new BorderLayout()) ;
	Canvas3D c = new Canvas3D(null) ;
	add("Center", c) ;

	// Create a simple scene and attach it to the virtual universe
	BranchGroup scene = createSceneGraph(cg) ;
	SimpleUniverse u = new SimpleUniverse(c) ;

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        u.getViewingPlatform().setNominalViewingTransform() ;
	u.addBranchGraph(scene) ;
    }

    //
    // The following allows cgview to be run as an application
    // as well as an applet.
    //
    public static void main(String[] args) {
	new MainFrame(new cgview(args), 700, 700) ;
    }
}
