


import javax.vecmath.*;
import javax.media.j3d.*;

public class AppearanceSet {

   public final Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
   public final Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
   public final Color3f red   = new Color3f(0.80f, 0.20f, 0.2f);
   public final Color3f blue   = new Color3f(0.40f, 0.40f, 0.80f);
   public final Color3f violet   = new Color3f(0.80f, 0.40f, 0.90f);
   public final Color3f green   = new Color3f(0.0f, 0.80f, 0.0f); 
   public final Color3f green1   = new Color3f(0.4f, 0.53f, 0.133f);   
   public final Color3f yellow   = new Color3f(0.80f, 0.80f, 0.2f);
   public final Color3f orange   = new Color3f(0.8f, 0.6f, 0.2f);
   public final Color3f ambientOrange   = new Color3f(0.4f, 0.3f, 0.1f);
   public final Color3f ambientWhite = new Color3f(0.2f,0.2f,0.2f);
   public final Color3f ambientRed = new Color3f(0.2f, 0.05f, 0.0f);
   public final Color3f ambientBlue = new Color3f(0.05f, 0.0f, 0.2f);
   public final Color3f ambientViolet = new Color3f(0.2f, 0.0f, 0.3f);
   public final Color3f ambientGreen = new Color3f(0.05f, 0.2f, 0.0f);
   public final Color3f ambientYellow = new Color3f(0.4f, 0.4f, 0.0f);
   public final Color3f ambient = new Color3f(0.2f, 0.2f, 0.2f);
   public final Color3f diffuse = new Color3f(0.7f, 0.7f, 0.7f);
   public final Color3f specular = new Color3f(0.7f, 0.7f, 0.7f);
   public final Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
   
   static public Appearance whiteAppearance;
   static public Appearance violetAppearance;
   static public Appearance redAppearance;
   static public Appearance blueAppearance;
   static public Appearance orangeAppearance;
   static public Appearance yellowAppearance;
   static public Appearance redAppearanceTransparent;
   static public Appearance whiteAppearanceTransparent;
   static public Appearance greenAppearance;
   static public Appearance green1Appearance;
   
   
   public AppearanceSet(){
   
      //red appearance
      Material redMaterial = new Material(ambientRed, black, red, specular, 75.0f);
      redMaterial.setLightingEnable(true);
      redAppearance = new Appearance();
      redAppearance.setMaterial(redMaterial);
      
      //blue appearance
      Material blueMaterial = new Material(ambientBlue, black, blue, specular, 75.0f);
      blueMaterial.setLightingEnable(true);
      blueAppearance = new Appearance();
      blueAppearance.setMaterial(blueMaterial);
      
      //violet appearance
      Material violetMaterial = new Material(ambientViolet, black, violet, specular, 75.0f);
      violetMaterial.setLightingEnable(true);
      violetAppearance = new Appearance();
      violetAppearance.setMaterial(violetMaterial);
      
      
      //orange appearance
      Material orangeMaterial = new Material(ambientOrange, black, orange, specular, 75.0f);
      orangeMaterial.setLightingEnable(true);
      orangeAppearance = new Appearance();
      orangeAppearance.setMaterial(orangeMaterial);
      
      //white appearance
      Material whiteMaterial = new Material(ambientWhite, black, white, specular, 30.0f);
      whiteMaterial.setLightingEnable(true);
      whiteAppearance = new Appearance();
      whiteAppearance.setMaterial(whiteMaterial);
      
      //yellow appearance
      Material yellowMaterial = new Material(ambientYellow, black, yellow, specular, 75.0f);
      yellowMaterial.setLightingEnable(true);
      yellowAppearance = new Appearance();
      yellowAppearance.setMaterial(yellowMaterial);
      
      //red transparent appearance
       
      redAppearanceTransparent = new Appearance();
      TransparencyAttributes ta_red = new TransparencyAttributes();
      ta_red.setTransparencyMode(ta_red.BLENDED);
      ta_red.setTransparency(0.6f);
      redAppearanceTransparent.setTransparencyAttributes(ta_red);
      redAppearanceTransparent.setMaterial(redMaterial);
      
      
      //white transparent appearance
       
      whiteAppearanceTransparent = new Appearance();
      TransparencyAttributes ta_white = new TransparencyAttributes();
      ta_white.setTransparencyMode(ta_white.BLENDED);
      ta_white.setTransparency(0.6f);
      whiteAppearanceTransparent.setTransparencyAttributes(ta_white);
      whiteAppearanceTransparent.setMaterial(whiteMaterial);
      
      // Create the green appearance node
      Material greenMaterial = new Material(ambientGreen, black, green, specular, 75.0f);
      greenMaterial.setLightingEnable(true);
      greenAppearance = new Appearance();
      greenAppearance.setMaterial(greenMaterial);
      
      // Create the green1 appearance node
      Material green1Material = new Material(ambientGreen, black, green1, specular, 75.0f);
      green1Material.setLightingEnable(true);
      green1Appearance = new Appearance();
      green1Appearance.setMaterial(green1Material);
         
   }      
   
   public static void main(String[] args){
   
      AppearanceSet my_appearances = new AppearanceSet();
      System.out.println(""+my_appearances.redAppearance);    
   
   }
   
}