import javax.media.j3d.*;
import javax.vecmath.*;


///////////////////////////////
public class ShapeConstructor {
///////////////////////////////
	
	
	private IndexedTriangleStripArray igsa;
	private Appearance app;
	
	private Point3f[] initVertices;
	private Point3f[] vertices;
	private int[] vertices_indices;
	
	private Color3f[] colors;
	private int[] colors_indices;
	
	private Vector3f[] initNormals;
	private Vector3f[] normals;
	private int[] normals_indices;
	
	private int[] stripCounts;
	private GeometryArray geometryArray;
	
	Shape3D shape;	
	//=========================================================================================
	public ShapeConstructor(	Point3f[] verts, int[] verts_indices,
														Vector3f[] norms, int[] norms_indices,
														Color3f[] colrs, int[] colrs_indices,
														int[] strip_counts){
	//=========================================================================================
	
	 			

		 		
		int num_verts = verts.length;
		int num_norms = norms.length;
		int num_colrs = colrs.length;
		int num_counts = verts_indices.length;
		
		
	
		//duplicate all arrays that might be modified
		initVertices = new Point3f[num_verts];
		vertices = new Point3f[num_verts];
		vertices_indices = verts_indices;
		for (int i=0;i<verts.length;i++){		
		
			vertices[i] = verts[i];
			initVertices[i] = verts[i];
			
		}//for
		
		initNormals = new Vector3f[num_norms];
		normals = new Vector3f[num_norms];
		normals_indices = norms_indices;
		System.out.println("norms.length = "+norms.length);
		for (int i=0;i<norms.length;i++){		
		
			normals[i] = norms[i];
			initNormals[i] = norms[i];
			
		}//for
				
		colors = colrs;
		colors_indices = colrs_indices;
		
		stripCounts = strip_counts;
		System.out.println("num_counts = "+num_counts);
			 
			
		igsa = new IndexedTriangleStripArray(	num_counts, 
																	GeometryArray.COORDINATES|GeometryArray.COLOR_3|GeometryArray.NORMALS,
																	num_counts, stripCounts);
																	
		igsa.setCapability(TriangleStripArray.ALLOW_COORDINATE_WRITE);
    igsa.setCapability(TriangleStripArray.ALLOW_COORDINATE_READ);
    igsa.setCapability(TriangleStripArray.ALLOW_NORMAL_WRITE);
    igsa.setCapability(TriangleStripArray.ALLOW_COLOR_WRITE);
    igsa.setCapability(TriangleStripArray.ALLOW_INTERSECT);

		igsa.setColors(0, colors);
		igsa.setColorIndices(0,colors_indices);
		igsa.setCoordinates(0,vertices);
		igsa.setCoordinateIndices(0,vertices_indices);
		igsa.setNormals(0,normals);
		igsa.setNormalIndices(0,normals_indices);
		
		//shape = new Shape3D(tsa);
	}
	
	//========================
	public void updateArray(){
	//========================
	
		igsa.setCoordinates(0, vertices);
		igsa.setNormals(0, normals); 
		igsa.setColors(0, colors); 
	
	}
	
	//======================================
	public IndexedTriangleStripArray getGeometry(){
	//======================================
		
		igsa.setCoordinates(0, vertices);
		igsa.setNormals(0, normals); 
		igsa.setColors(0, colors); 
		return igsa;
		
	} 

	//========================
	public Shape3D getShape(){
	//========================
	
		return new Shape3D(igsa);	
		
		
		
	}
	
}