/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.spec.ReferenceTypeSpec;

public abstract class EventRequestSpec
implements Protocol {
    private final Long myID;
    public static final Object expressionKey = "expr";
    private String expr = null;
    public static final Object threadKey = "thread";
    private Object thread = null;
    private int suspendPolicy = 2;
    private List classFilters = null;
    private List classExFilters = null;
    boolean isResolved = false;
    public static final Object specPropertyKey = "spec";
    final Application app;
    ReferenceTypeSpec refSpec;
    EventRequest request = null;

    public EventRequestSpec(Application app, ReferenceTypeSpec refSpec) {
        this.app = app;
        this.refSpec = refSpec;
        this.myID = app.getNewID();
    }

    void attemptImmediateResolve(VirtualMachine vm) {
        Iterator<ReferenceType> iter = vm.allClasses().iterator();
        while (iter.hasNext()) {
            ReferenceType refType = iter.next();
            if (!this.refSpec.matches(refType)) continue;
            try {
                if (!this.resolve(refType)) continue;
                this.setIsResolved();
            }
            catch (JDEException ex) {
                this.app.removeSpecAndInformJDE(this, ex.getMessage());
            }
            catch (Exception exception) {
                this.app.removeSpecAndInformJDE(this, "Error resolving spec");
            }
        }
    }

    public void attemptResolve(ReferenceType refType) {
        block4: {
            if (this.isResolved() || !this.refSpec.matches(refType)) break block4;
            try {
                if (this.resolve(refType)) {
                    this.setIsResolved();
                }
            }
            catch (JDEException ex) {
                this.app.removeSpecAndInformJDE(this, ex.getMessage());
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.app.removeSpecAndInformJDE(this, "Error resolving spec: " + ex.toString());
            }
        }
    }

    public EventRequest getEventRequest() {
        return this.request;
    }

    public Long getID() {
        return this.myID;
    }

    private void installClassExFilters(EventRequest request) {
        if (this.classExFilters == null) {
            return;
        }
        Iterator iter = this.classExFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassExclusionFilter(f);
        }
    }

    private void installClassFilters(EventRequest request) {
        if (this.classFilters == null) {
            return;
        }
        Iterator iter = this.classFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassFilter(f);
        }
    }

    boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    abstract boolean resolve(ReferenceType var1) throws JDEException;

    public void setClassExFilters(List filters) {
        this.classExFilters = filters;
        if (this.request != null) {
            this.installClassExFilters(this.request);
        }
    }

    public void setClassFilters(List filters) {
        this.classFilters = filters;
        if (this.request != null) {
            this.installClassFilters(this.request);
        }
    }

    public void setExpression(String expr) {
        this.expr = expr;
        if (this.request != null) {
            this.request.putProperty("expr", expr);
        }
    }

    public void setIsResolved() {
        this.isResolved = true;
    }

    void setRequest(EventRequest request) {
        this.request = request;
        request.putProperty("spec", this);
        request.putProperty("thread", this.thread);
        request.putProperty("expr", this.expr);
        request.setSuspendPolicy(this.suspendPolicy);
        this.installClassFilters(request);
        this.installClassExFilters(request);
        request.enable();
        this.app.informJDEInstallSuccessful(this);
    }

    public void setSuspendPolicy(int policy) {
        this.suspendPolicy = policy;
        if (this.request != null) {
            this.request.setSuspendPolicy(policy);
        }
    }

    public void setThread(Object thread) {
        this.thread = thread;
        if (this.request != null) {
            this.request.putProperty("thread", thread);
        }
    }
}

