/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.JDEException;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.PatternReferenceTypeSpec;
import jde.debugger.spec.ReferenceTypeSpec;
import jde.debugger.spec.SourceNameReferenceTypeSpec;

public class MethodBreakpointSpec
extends BreakpointSpec {
    String methodName;
    List methodArgs;

    public MethodBreakpointSpec(Application app, ReferenceTypeSpec refSpec, String methodName, List methodArgs) {
        super(app, refSpec);
        this.methodName = methodName;
        this.methodArgs = methodArgs;
    }

    private boolean compareArgTypes(Method method, List nameList) {
        List<String> argTypeNames = method.argumentTypeNames();
        if (argTypeNames.size() != nameList.size()) {
            return false;
        }
        int i = 0;
        while (i < argTypeNames.size()) {
            String comp2;
            String comp1 = argTypeNames.get(i);
            if (!comp1.equals(comp2 = (String)nameList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ClassType clazz) throws JDEException {
        Iterator<Method> iter;
        ArrayList<String> argTypeNames = null;
        if (this.methodArgs != null) {
            argTypeNames = new ArrayList<String>(this.methodArgs.size());
            iter = this.methodArgs.iterator();
            while (iter.hasNext()) {
                String name = (String)((Object)iter.next());
                name = this.normalizeArgTypeName(name);
                argTypeNames.add(name);
            }
        }
        iter = clazz.methods().iterator();
        Method firstMatch = null;
        Method exactMatch = null;
        int matchCount = 0;
        while (iter.hasNext()) {
            Method candidate = iter.next();
            if (!candidate.name().equals(this.getMethodName())) continue;
            if (++matchCount == 1) {
                firstMatch = candidate;
            }
            if (argTypeNames == null || !this.compareArgTypes(candidate, argTypeNames)) continue;
            exactMatch = candidate;
            break;
        }
        Method method = null;
        if (exactMatch != null) {
            return exactMatch;
        }
        if (argTypeNames != null) throw new JDEException("No method named '" + this.methodName + "' in class.");
        if (matchCount <= 0) throw new JDEException("No method named '" + this.methodName + "' in class.");
        if (matchCount != 1) throw new JDEException("Ambiguous method '" + this.methodName + "'. Specify arguments.");
        return firstMatch;
    }

    private Location getLocation(ClassType clazz) throws JDEException {
        Method method = this.findMatchingMethod(clazz);
        Location location = method.location();
        return location;
    }

    public List getMethodArgs() {
        return this.methodArgs;
    }

    public String getMethodName() {
        return this.methodName;
    }

    private boolean isValidMethodName(String s) {
        return this.isJavaIdentifier(s) || s.equals("<init>") || s.equals("<clinit>");
    }

    private String normalizeArgTypeName(String name) throws JDEException {
        char c;
        int i = 0;
        StringBuffer typePart = new StringBuffer();
        StringBuffer arrayPart = new StringBuffer();
        name = name.trim();
        while (i < name.length()) {
            c = name.charAt(i);
            if (Character.isWhitespace(c) || c == '[') break;
            typePart.append(c);
            ++i;
        }
        while (i < name.length()) {
            c = name.charAt(i);
            if (c == '[' || c == ']') {
                arrayPart.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new JDEException("At least one of the arguments of method '" + this.methodName + "' is invalid.");
            }
            ++i;
        }
        name = typePart.toString();
        if (name.indexOf(46) == -1 || name.startsWith("*.")) {
            try {
                List refs = this.app.findClassesMatchingPattern(name);
                if (refs.size() > 0) {
                    name = ((ReferenceType)refs.get(0)).name();
                    if (refs.size() > 1) {
                        this.app.signal("warning", "(Method Breakpoint Warning) More than one classes matched resolving an argument for method '" + this.methodName + "'. Defaulting to the first match.");
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        name = String.valueOf(name) + arrayPart.toString();
        return name;
    }

    boolean resolve(ReferenceType refType) throws JDEException {
        if (!this.isValidMethodName(this.methodName)) {
            throw new JDEException("'" + this.methodName + "' is not a valid method name.");
        }
        if (!(refType instanceof ClassType)) {
            throw new JDEException("'" + refType + "' is not a Class");
        }
        Location location = this.getLocation((ClassType)refType);
        if (location == null) {
            throw new JDEException("Can't set breakpoint on an abstract/native method");
        }
        BreakpointRequest br = refType.virtualMachine().eventRequestManager().createBreakpointRequest(location);
        this.setRequest(br);
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("break in_method ");
        if (this.refSpec instanceof SourceNameReferenceTypeSpec) {
            buffer.append(((SourceNameReferenceTypeSpec)this.refSpec).getSourceName());
        } else if (this.refSpec instanceof PatternReferenceTypeSpec) {
            buffer.append(((PatternReferenceTypeSpec)this.refSpec).getClassPattern());
        }
        buffer.append(" " + this.methodName + " ");
        if (this.methodArgs != null) {
            Iterator iter = this.methodArgs.iterator();
            boolean first = true;
            buffer.append('(');
            while (iter.hasNext()) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append((String)iter.next());
                first = false;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

