package com.iintiip.suncertify.db;

import java.io.*;

/**
 * This class embodies the name of a field and the maximum width 
 * that it may have.
 *
 * @version 1.0  11-Sep-1997
 */
public class Field implements Serializable {
  private String name;
  private int length;
  final static char sc = 'A';

  /**
   * This constructs an initialized Field object.
   *
   * @param String name - the name of the field.
   * @param int length - the length of the field.
   */
  public Field(String name, int length) {
    this.name = name;
    this.length = length;
  }

  /**
   * This method returns the name of the field.
   *
   * @returns String - the name of the field.
   */
  public String getName() {
    return name;
  }

  /**
   * This method returns the length of the field.
   *
   * @returns int - the length of the field.
   */
  public int getLength() {
    return length;
  }

  /**
   * This method constructs and returns a String which describes 
   * this Field object in a form suitable for debug output.
   *
   * @returns String - A textual representation of this DataInfo.
   */
  public String toString() {
    return ("Name=" + name.trim() + ", length=" + length);
  }
}
