/***************************
 * 
 * Name:       $Name:  $
 * Author:     $Id: TestDatabase.java,v 1.1 2000/08/04 20:54:46 lbtynor Exp $
 * Version:    $Revision: 1.1 $
 * Copyright:  IinTiip Software, Inc.  2000
 *
 ***************************/


package com.iintiip.suncertify.db;
import junit.framework.*;
import java.io.*;
 
 
 
/**
 * 
 * Class: TestDatabase2.java
 * Created: Wed Aug  2 18:02:31 2000
 *
 * @author Laurie Tynor
 * @version
 * 
 * 
 * Class TestDatabase2 is ... 
 **/
public class TestDatabase2 extends TestCase {
  private static final String fileName = "/tmp/TestDb";

  public TestDatabase2 (String name) {
    super(name);
  }
  

  
  public void testAddRecords() {
    File f = new File(fileName);
    Database db = createDb(f);
    Record record=null;
    String[] values1;
    String[] values2;

    addRecords(db, 8);
    System.out.println(db);
    assertEquals(db.getRecordCount(), 8);
    for (int i=1; i<=8; ++i) {
      try {
	record = db.getRecord(i);
	values1 = record.getValues();
	values2 = createValues(i);
	for (int j=0; j<values1[i].trim().length(); ++j) {
	  assertEquals(values1[i].trim(), values2[i].trim());
	}
      }
      catch (Exception e) {
	 fail("Exception thrown getting record from database: " + getExceptionString(e));
      }
    }
    db.close();
    f.delete();
  }



  private Database createDb(File f) {
    if (f.exists()) {
      try {
	f.delete();
      }
      catch (Exception e) {}
    }
    assert ("Db already exists, so can't create from scratch", !f.exists());
    Field[] fields = buildField();
    Database db = null;
    try {
      db = new Database(f.toString(), fields);
    }
    catch (Exception e) {
      fail("Exception thrown creating database from scratch: " + getExceptionString(e));
    }
    assert ("Testing existence of created db", f.exists());
    assertEquals(db.getRecordCount(), 0);
    return db;
  }

  private void addRecords(Database db, int num) {
    String[] values;
    for (int i=1; i<=num; ++i) {
      values = createValues(i); 
      try {
	db.addRecord(values);
      }
      catch (Exception e) {
	 fail("Exception thrown adding values to database: " + getExceptionString(e));
      }
    }
  }

  private Field[] buildField() {
    Field[] fields = new Field[9];
    fields[0] = new Field("flightNumber", 5);
    fields[1] = new Field("origin", 30);
    fields[2] = new Field("destination", 30);
    fields[3] = new Field("carrier", 40);
    fields[4] = new Field("cost", 8);
    fields[5] = new Field("date", 10);
    fields[6] = new Field("time", 10);
    fields[7] = new Field("duration", 15);
    fields[8] = new Field("seatsAvail", 4);
    return fields;
  }
    
  private String[] createValues(int i) {
    String[] data = new String[9];
    data[0] = Integer.toString(i);
    data[1] = new String("Origin" + i);
    data[2] = new String("Destination" + i);
    data[3] = new String ("Carrier" + i);
    data[4] = Float.toString((i+.50f)*100);
    data[5] = new String("2000-08-02");
    data[6] = new String("1440");
    data[7] = Integer.toString(i*10);
    data[8] = Integer.toString(i+10);
    return data;
  }

  private String getExceptionString(Exception e) {
    StringWriter sw = new StringWriter(1000);
    e.printStackTrace(new PrintWriter(sw));
    return sw.toString();
  }

}
