/***************************
 * 
 * Name:       $Name:  $
 * Author:     $Id: TestRunnerIT.java,v 1.7 2000/08/03 19:31:48 lbtynor Exp $
 * Version:    $Revision: 1.7 $
 * Copyright:  IinTiip Software, Inc.  2000
 *
 ***************************/


package com.iintiip.test;

import junit.framework.*;
import junit.util.*;
import junit.textui.TestRunner;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;



/**
 * TestRunner.java
 *
 *
 * Created: Thu Jul 20 17:11:31 2000
 *
 * TestRunner is the harness for junit.  It's based on junit's textui TestRunner.
 */


public class TestRunnerIT2 implements TestListener{

  private PrintStream ps;
  private boolean debug=false;
  private static final String TEST_SUITE = "suite";

  public TestRunnerIT2 () {}
  public TestRunnerIT2 (PrintStream ps_) {
    ps = ps_;
  }
  
  /**
   * main entry point.
   */
  public static void main(String args[]) {
    TestRunnerIT2 aTestRunnerIT2= new TestRunnerIT2();
    Vector testNames = new Vector();
    String testClass = "com.iintiip.suncertify.db.TestDatabase2";
    testNames.add("testAddRecords");
    
    aTestRunnerIT2.start(new TestData(testClass, testNames, null));
  }

  
  
  /**
   * Starts a test run. Analyzes the command line arguments
   * and runs the given test suite.
   */
  protected void start(TestData testData) {
    String className = testData.getClassName();
    Vector testNames = testData.getTestNames();
    String testOwner = testData.getTestOwner();
    boolean testAll = testData.getTestAll();
    
    Class[] paramTypes = new Class[1];
    Object[] params = new Object[1];
    Constructor testConstructor = null;
    Class testClass= null;
    Method suiteMethod= null;
    TestSuite suite= null;
    Test test=null;
    
    try{
      testClass= Class.forName(className);
    } catch(ClassNotFoundException e){
      ps().println("Suite class '"+className+ "' not found");
      return;
    }
    debug("Found class: " + className);
    
    // If you are supposed to run all tests for the class, then run the suite
    // for the test class
    if (testAll == true) {
      try{
	// Get the suite method defined in the class.
	// You can then get the suite by invoking this method
	suiteMethod= testClass.getMethod(TEST_SUITE, null);
	suite= (TestSuite)suiteMethod.invoke(testClass, null);
	debug("Got suite via suiteMethod");
      } catch(Exception e){
	// Can't get the suite from the suite method,
	// so try to create a test suite automatically
	// This will make a suite which has all methods
	// for the class that start with "test"
	debug("Trying to make automatic suite");
	suite= new TestSuite(testClass);
	debug("Made automatic suite");
      }
      
      if (suite == null) {
	ps().println("Cannot find suite for the test class: " + testClass);
	debug("Cannot find suite for the test class: " + testClass);
      }
      debug("Found suite for test class: " + testClass);
    }
    
    // If individual tests for the class have been specified, then run
    // just the specified tests for the class rather than the whole
    // suite for the class
    else {
      suite = new TestSuite();
      try {
	paramTypes[0] =  Class.forName("java.lang.String");
	testConstructor = testClass.getConstructor(paramTypes);
	for (Enumeration e = testNames.elements(); e.hasMoreElements(); ) {
	  params[0] = (String)e.nextElement();
	  test = (TestCase)testConstructor.newInstance(params);
	  ((TestSuite)suite).addTest(test);	   
	}
      }
      catch (Exception e) {
	error("Exception creating test suite from test name list");
	error(e);
      }
    }

    if (suite != null) {
     doRun((TestSuite)suite, testOwner, className);
    }
    else {
      error("Could not create and run test suite: " + className);
    }
  }


  /**
   * Return stream to direct output to
   **/
  private PrintStream ps() {
    if (ps == null) {
      return System.out;
    }
    return ps;
  }

  /**
   * Output string to ps() if in debug mode (set in properties file)
   **/
  private void debug(String str) {
    if (debug == true) {
      ps().println(str);
    }
  }

  /**
   * Output string to ps() regardless of debug mode
   **/
  private void error(String str) {
    ps().println("ERROR: " + str);
  }

  /**
   * Output exception to ps() regardless of debug mode
   **/
  private void error(Exception e) {
    e.printStackTrace(ps());
  }
    
  /**
   * Called for each test suite run
   **/
  protected void doRun(TestSuite suite, String testOwner, String suiteName) {
    TestResult result=new TestResult();
    result.addListener(this);
    long startTime= System.currentTimeMillis();
    suite.run(result);
    long endTime= System.currentTimeMillis();
    long runTime= endTime-startTime;
    ps().println();
    ps().println("-----------------------------------------------------");
    ps().println("Test suite: " + suiteName);
    ps().print("Test cases in suite:  ");
    for (int i=0; i<suite.testCount(); ++i) {
      TestCase test = (TestCase)suite.testAt(i);
      ps().print(test.name() + "  ");
    }
    ps().println();
    ps().println("Running Time: " +StringUtil.elapsedTimeAsString(runTime));
    print(result);
    ps().println();
  }



  /**
   * 
   **/
  public synchronized void addError(Test test, Throwable t) {
    debug("Added Error for test " + test);
  }
  
  /**
   * 
   **/
  public synchronized void addFailure(Test test, Throwable t) {
    debug("Added Failure for test " + test);
  }
  
  
  public void startTest(Test test) {}
  public void endTest(Test test) {}
  
  
  /**
   * Prints failures to the standard output
   */
  public synchronized void print(TestResult result) {
    printHeader(result);
    printErrors(result);
    printFailures(result);
  }
  
  /**
   * Prints the errors to the standard output
   */
  public void printErrors(TestResult result) {
    if (result.errorCount() != 0) {
      if (result.errorCount() == 1)
	ps().println("There was "+result.errorCount()+" error:");
      else
	ps().println("There were "+result.errorCount()+" errors:");
      ps().println(getFailureString(result));
      ps().println();
    }
  }

	
  /**
   * Prints failures to the standard output
   */
  public void printFailures(TestResult result) {
    if (result.failureCount() != 0) {
      if (result.failureCount() == 1)
	ps().println("There was "+result.failureCount()+" failure:");
      else
	ps().println("There were "+result.failureCount()+" failures:");
      ps().println(getFailureString(result));
      ps().println();
    }
  }


  /**
   * Returns a string with details of failures
   */
  public String getFailureString(TestResult result) {
    String str = new String();
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    PrintStream ps = new PrintStream(bos);
    int i = 1;
    debug("In getFailureString with result: " + result);
    for (Enumeration e= result.failures(); e.hasMoreElements(); i++) {
      TestFailure failure= (TestFailure) e.nextElement();
      str = str + i + ") " + failure.failedTest();
      debug("And str now is: " + str);
      Throwable t= failure.thrownException();
      if (t.getMessage() != null)
	str = str + " \"" + t.getMessage() + "\" \n";
      else {
	failure.thrownException().printStackTrace(ps);
	str = str + "\n" + bos.toString() + "\n";
      }
      debug("And str now is: " + str);
    }
    return str;
  }
	
  /**
   * Prints the header of the report
   */
  public void printHeader(TestResult result) {
    if (result.wasSuccessful()) {
      ps().print("OK");
      ps().println (" (" + result.runCount() + " tests)");
      
    } else {
      ps().println();
      ps().print("FAILURES OR ERRORS!!!");
      ps().println(" (" + result.runCount() + " tests:  " + result.failureCount() + " failures, " + result.errorCount() + " errors)" ); 
    }
  }
  
  
} // TestRunnerIT2






class TestData {
  private String className = null;
  private Vector testNames = null;
  private boolean testAll = false;
  private String testOwner = null;
  
  public TestData(String c, Vector t, String o) {
    className = c;
    testNames = t;
    if (testNames==null) {
      testAll = true;
    }
    testOwner = o;
  }
  public String getClassName() {return className;}
  public Vector getTestNames() {return testNames;}
  public boolean getTestAll() {return testAll;}
  public String getTestOwner() {return testOwner;}
  public String toString() {
    return new String("TestData " + this.hashCode() + ": className=" + className + ", testOwner=" + testOwner + ", testAll=" + testAll + ", testNames=" + testNames);
  }
}
