/*
 * The contents of this file are subject to the JOnAS Public License Version 
 * 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License on the JOnAS web site.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific terms governing rights and limitations under 
 * the License.
 *
 * The Original Code is JOnAS application server code released July 1999.
 *
 * The Initial Developer of the Original Code is Bull S.A.
 * The Original Code and portions created by Bull S.A. are
 *    Copyright (C) 1999 Bull S.A. All Rights Reserved.
 *
 * Contributor(s): ______________________________________.
 *
 * --------------------------------------------------------------------------
 * $Id: OpBean.java,v 1.1 2000/10/11 09:04:34 jonas Exp $
 * --------------------------------------------------------------------------
 */

package sb;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.naming.InitialContext;
import javax.naming.NamingException;

// This is an example of Session Bean, statefull, and synchronized.

public class OpBean implements SessionBean, SessionSynchronization {

    protected int total = 0;	// actual state of the bean
    protected int newtotal = 0;	// value inside Tx, not yet committed.
    protected String clientUser = null;
    protected SessionContext sessionContext = null;

    /*========================= ejbCreate methods ============================*/

    /**
     * There must be one ejbCreate() method per create() method on the Home interface, 
     *  and with the same signature.
     */
    public void  ejbCreate(String user) {

	total = 0;
	newtotal = total;	// in case we are outside transactions
	clientUser = user;
    }

    /*====================== javax.ejb.SessionBean implementation =================*/

    /**
     * This method is called when the instance is activated from its "passive" state.
     * The instance should acquire any resource that it has released earlier in the 
     * ejbPassivate() method. 
     * This method is called with no transaction context.
     * 
     * @exception EJBException  Thrown by the method to indicate a failure 
     *                          caused by a system-level error.
     */
    public void ejbActivate() {
	// Nothing to do for this simple example
    }


    /**
     * This method is called before the instance enters the "passive" state. 
     * The instance should release any resources that it can re-acquire later in the 
     *  ejbActivate() method.
     * After the passivate method completes, the instance must be in a state that 
     *  allows the container to use the Java Serialization protocol to externalize 
     *  and store away the instance's state. 
     * This method is called with no transaction context. 
     *
     * @exception EJBException  Thrown by the method to indicate a failure 
     *                          caused by a system-level error.
     */
    public void ejbPassivate() {
	// Nothing to do for this simple example
    }


    /**
     * A container invokes this method before it ends the life of the session object. 
     * This happens as a result of a client's invoking a remove operation, or when a 
     *  container decides to terminate the session object after a timeout. 
     * This method is called with no transaction context. 
     *
     * @exception EJBException  Thrown by the method to indicate a failure 
     *                          caused by a system-level error.
     * @exception RemoteException - This exception is defined in the method signature
     *                           to provide backward compatibility for enterprise beans
     *                           written for the EJB 1.0 specification. 
     *                           Enterprise beans written for the EJB 1.1 and 
     *                           higher specification should throw the javax.ejb.EJBException 
     *                           instead of this exception. 
     */
    public void ejbRemove() {
	// Nothing to do for this simple example
    }


    /** 
     * Sets the associated session context. The container calls this method after the instance
     *  creation. 
     * The enterprise Bean instance should store the reference to the context object 
     *  in an instance variable. 
     * This method is called with no transaction context. 
     *
     * @param sessionContext - A SessionContext interface for the instance. 
     * @exception RemoteException - Thrown if the instance could not perform the function 
     *            requested by the container because of a system-level error. 
     */
    public void setSessionContext(SessionContext sessionContext) {
	this.sessionContext = sessionContext;
    }

    /*============== javax.ejb.SessionSynchronization implementation =============*/

    /** 
     * The afterBegin method notifies a session Bean instance that a new transaction has started,
     *  and that the subsequent business methods on the instance will be invoked in the context of
     *  the transaction. 
     *
     * @exception EJBException : system-level error. 
     */
    public void afterBegin() {
	newtotal = total;
    }

    /** 
     *  The beforeCompletion method notifies a session Bean instance that a transaction 
     *  is about to be committed.
     *    
     * @exception EJBException : system-level error. 
     */
    public void beforeCompletion() {
	// Nothing to do for this simple example

	// We can access the bean environment everywhere in the bean,
	// for example here!
	try {
	    InitialContext ictx = new InitialContext();
	    String value = (String) ictx.lookup("java:comp/env/prop1");
	    // value should be the one defined in ejb-jar.xml
	} catch (NamingException e) {
	    throw new EJBException(e);
	}
    }

    /** 
     *  The afterCompletion method notifies a session Bean instance that a transaction commit
     *   protocol has completed, and tells the instance whether the transaction has been committed
     *   or rolled back. 
     *
     *  @param : committed - True if the transaction has been committed, false if is has been rolled back.
     *
     *  @exception EJBException : system-level error. 
     */
    public void afterCompletion(boolean committed) {
	if (committed) {
	    total = newtotal;
	} else {
	    newtotal = total;
	}
    }


    /*========================= Op implementation ============================*/

    /**
     * Business method implementation.
     * @param s  nb of shares to be bought
     */
    public void buy(int s) {
	newtotal = newtotal + s;
	return;
    }

    /**
     * Business method implementation.
     * @return  the nb of shares bought
     */
    public int read() {
	return newtotal;
    }
}
