/* definition of struct path */
struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};
void path_put(struct path *path)
{
        dput(path->dentry);
        mntput(path->mnt);
}
void path_get(struct path *path)
{
        mntget(path->mnt);
        dget(path->dentry);
}
void fsstack_copy_inode_size(struct inode *dst, const struct inode *src)
{
        i_size_write(dst, i_size_read((struct inode *)src));
        dst->i_blocks = src->i_blocks;
}
static inline void fsstack_copy_attr_times(struct inode *dest,
                                           const struct inode *src)
{
     dest->i_atime = src->i_atime;
     dest->i_mtime = src->i_mtime;
     dest->i_ctime = src->i_ctime;
}
static inline void fsstack_copy_attr_atime(struct inode *dest,
const struct inode *src)
{
      dest->i_atime = src->i_atime;
}

void fsstack_copy_attr_all(struct inode *dest, const struct inode *src,
				int (*get_nlinks)(struct inode *))
{
	dest->i_mode = src->i_mode;
	dest->i_uid = src->i_uid;
	dest->i_gid = src->i_gid;
	dest->i_rdev = src->i_rdev;
	dest->i_atime = src->i_atime;
	dest->i_mtime = src->i_mtime;
	dest->i_ctime = src->i_ctime;
	dest->i_blkbits = src->i_blkbits;
	dest->i_flags = src->i_flags;

	/*
	 * Update the nlinks AFTER updating the above fields, because the
	 * get_links callback may depend on them.
	 */
	if (!get_nlinks)
		dest->i_nlink = src->i_nlink;
	else
		dest->i_nlink = (*get_nlinks)(dest);
}
