#!/bin/bash

BUILD_ROOT="/root/microhttpd-build"
INST_ROOT="/opt/mhd"

LDFLAGS="-L${INST_ROOT}/lib64 -Wl,-rpath,${INST_ROOT}/lib64"
CPPFLAGS="-I${INST_ROOT}/include"
CFLAGS="-g -O0"
PKG_CONFIG_PATH="${INST_ROOT}/lib64/pkgconfig"
PATH="/usr/libexec/binutils220:${PATH}"

export LDFLAGS CPPFLAGS CFLAGS PKG_CONFIG_PATH PATH

[ -d /usr/libexec/binutils220 ] || yum install binutils220

# libffi
cd ${BUILD_ROOT}/libffi-3.2.1 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64" CPPFLAGS="-I${INST_ROOT}/include"
make
make install

# libgpg-error
cd ${BUILD_ROOT}/libgpg-error-1.27 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64"
make
make install

# libtasn1
cd ${BUILD_ROOT}/libtasn1-4.12 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64"
make
make install

# p11-kit
cd ${BUILD_ROOT}/p11-kit-0.23.2 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64"
make
make install

# gmp
cd ${BUILD_ROOT}/gmp-6.1.2 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64"
make
make install

# nettle
cd ${BUILD_ROOT}/nettle-3.3 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64"
make
make install

# gnutls
cd ${BUILD_ROOT}/gnutls-3.6.0 || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64" --with-included-unistring
make
make install

# libmicrohttpd
cd ${BUILD_ROOT}/libmicrohttpd-0.9.55-git || exit 1
./configure --prefix="${INST_ROOT}" --libdir="${INST_ROOT}/lib64" --with-gnutls --enable-https=yes
make

