#include <stdio.h>
#include <stdlib.h>
#include "crtest.h"

#if defined(__CYGWIN__)
#  define HAVE_FORK
#endif

#if !defined(RUNTIME_PSEUDO_RELOC_SUPPORT)
#include <windows.h>
typedef struct
  {
    DWORD addend;
    DWORD target;
  }
runtime_pseudo_reloc;

extern runtime_pseudo_reloc __RUNTIME_PSEUDO_RELOC_LIST__;
extern runtime_pseudo_reloc __RUNTIME_PSEUDO_RELOC_LIST_END__;
extern void* _data_start__;
extern void* _image_base__;

void
_pei386_runtime_relocator (runtime_pseudo_reloc* start, runtime_pseudo_reloc* end)
{
  DWORD reloc_target;
  runtime_pseudo_reloc* r;
  for (r = start; r < end; r++)
    {
      printf ("ptr=%x, addend=%d\n", (long)r->target, r->addend);
      reloc_target = (DWORD) &_image_base__ + r->target;
      printf ("reloc target=%x\n", reloc_target);
      *((DWORD*) reloc_target) += r->addend;
    }
}
#endif

void
print_data ()
{
  printf ("data=%d %d %c\n", foo[0].x, foo[1].y[2], foo[1].z[1]);
}

int
main ()
{
  int pid;
#if !defined(RUNTIME_PSEUDO_RELOC_SUPPORT)
  _pei386_runtime_relocator (&__RUNTIME_PSEUDO_RELOC_LIST__,
                             &__RUNTIME_PSEUDO_RELOC_LIST_END__);
#endif
#if defined(RUNTIME_PSEUDO_RELOC_SUPPORT) && defined(HAVE_FORK)
  switch (pid = fork ())
    {
    case -1:
      perror ("fork");
      break;
    case 0:
      printf ("child: ");
      print_data ();
      break;
    default:
      wait (NULL);
      printf ("parent: ");
      print_data ();
      break;
    }
#else
  print_data ();
#endif
  return 0;
}
