echo \#
echo \# compile module
libtool --tag=CC --mode=compile gcc -o module.o -c module.c
echo \#
echo \# link convenience module
libtool --tag=CC --mode=link gcc -o libmodule.la module.lo -lz
echo \#
echo \# compile core library
libtool --tag=CC --mode=compile gcc -o core.o -c core.c
echo \#
echo \# link core library
libtool --tag=CC --mode=link gcc -o libcore.la -rpath /usr/local/lib \
	-version-info 0:1:0 -no-undefined -export-symbols core.exp \
	core.lo libmodule.la
echo \#
echo \# link shared module
libtool --tag=CC --mode=link gcc -o module.la -rpath /path/to/modules \
	-shared -module -no-undefined -avoid-version -export-symbol \
	module.exp libmodule.la libcore.la
echo \#
echo \# compile program
libtool --tag=CC --mode=compile gcc -o prog.o -c prog.c
echo \#
echo \# link program with shared core library
libtool --tag=CC --mode=link gcc -o shared-prog prog.o libcore.la
echo \#
echo \# link program with static core library
libtool --tag=CC --mode=link gcc -static -o static-prog prog.o libcore.la
