#include <stdio.h>

int
core(void)
{
	return 42;
}

#ifndef PIC

int module(void);

void
core_init(void)
{
	printf("static-module %d\n", module());
}

#else

#include <dlfcn.h>

typedef int (*module_t)(void);

void
core_init(void)
{
	/* this is not portable, but I have only included the
	 * "unix" implementation in this example.
	 */
	module_t module;
	void *handle;
	handle = dlopen(".libs/module.so", RTLD_GLOBAL);
	if (!handle) {
		printf("shared-module -1\n");
		return;
	}
	module = dlsym(handle, "module");
	if (!module) {
		printf("shared-module -2\n");
		return;
	}
	printf("shared-module %d\n", module());
}

#endif
