#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "kuser.h"
#include "kuser-private.h"

static int recursive_failure = 0;

__attribute__ (( visibility ("hidden") )) void *__kuser_resolve(char const *name, unsigned index)
{
	if(__kernel_helper_version() < index) {
		fprintf(stderr, "%s: %s\n", name, strerror(ENOSYS));

		if(recursive_failure++)
			abort();
		else
			exit(EXIT_FAILURE);
	}

	/* otherwise */

	return (void *)(__kuser_base - 0x20 * index);
}
