#ifndef EVENT_H
#define EVENT_H

#include <pthread.h>

class CEvent {
public:
	CEvent() {
		pthread_mutex_init(&mutex,NULL);
		pthread_cond_init(&event,NULL);
		signaled = false;
	}
	virtual ~CEvent() {
		pthread_cond_destroy(&event);
		pthread_mutex_destroy(&mutex);
	}
	void signal() {
		pthread_mutex_lock(&mutex);
		signaled = true;
		pthread_cond_broadcast(&event);
		pthread_mutex_unlock(&mutex);
	}
	void clear() {
		pthread_mutex_lock(&mutex);
		signaled = false;
		pthread_mutex_unlock(&mutex);
	}
	void wait() {
		pthread_mutex_lock(&mutex);
		while(!signaled) pthread_cond_wait(&event,&mutex);
		pthread_mutex_unlock(&mutex);
	}
private:
	bool signaled;
	pthread_mutex_t mutex;
	pthread_cond_t event;
};

#endif
