/***************************************************************************
                          cscheduler.cpp  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001 by Danny Shumock
    email                : dshumock@shumock.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cscheduler.h"

#include <signal.h>
#include <sys/time.h>
#include <stddef.h>

#include <Event.h>

static bool initialized = false;
static CEvent evt;

static void signal_handler(int sig)
{
	if(sig==SIGALRM) {
		evt.signal();	
	}
}

CScheduler::CScheduler(int milliseconds)
{
	initialized = true;
	sigset_t sigs;
	sigemptyset(&sigs);
	struct sigaction act;
	act.sa_handler = signal_handler;
	act.sa_mask = sigs;
	act.sa_flags = 0;
	sigaction(SIGALRM,&act,NULL);
	
	itimerval val;
	val.it_interval.tv_sec = milliseconds/1000;
	val.it_interval.tv_usec = (milliseconds-val.it_interval.tv_sec*1000)*1000;
	val.it_value.tv_sec = val.it_interval.tv_sec;
	val.it_value.tv_usec = val.it_interval.tv_usec;
	setitimer(ITIMER_REAL,&val,NULL);	
}

CScheduler::~CScheduler()
{
	itimerval val;
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value.tv_sec = 0;
	val.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL,&val,NULL);
	
	struct sigaction act;
	act.sa_handler = signal_handler;
	sigset_t sigs;
	sigemptyset(&sigs);
	act.sa_mask = sigs;
	act.sa_flags = 0;
	sigaction(SIGALRM,&act,NULL);
}

void CScheduler::wait()
{
	evt.wait();
	evt.clear();
}
