#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "fileio.h"

char **read_file(const char *filename)
{
	char buff[1024];
	char **index;
	int size, count;
	FILE *fp;

	fp = fopen(filename, "r");

	if (!fp)
	{
		fprintf(stderr, "Cannot open config file\n");
		exit(1);
	}

	size = 16;
	index = malloc(size * sizeof(char *));

	for (count = 0; ; count++)
	{
		if (!fgets(buff, sizeof(buff), fp))
			break;

		if (count >= size - 1)
		{
			size *= 2;
			index = realloc(index, size * sizeof(char *));
		}

		index[count] = strdup(buff);
	}

	index[count] = NULL;

	fclose(fp);

	return index;
}
