#!/bin/sh
#######################################################
# w_scan start script
# 20060710 wirbel (handygewinnspiel AET gmx D*T de)
#
# cu@vdr-portal
#
#######################################################

umask 022
export PATH="/bin:/usr/bin:/sbin:/usr/sbin:$(pwd)"
DATE="$(date +%Y)$(date +%m)$(date +%d)" # $DATE == "YYYYMMDD", i.e. 20060710
W_SCAN=$(which w_scan 2>/dev/null)

# Width of the Screen
COLUMNS=$(stty size)
COLUMNS=${COLUMNS##* }
if [ "$COLUMNS" = "0" ]; then
	COLUMNS=80;
fi

# Measurements for positioning result messages
COL=$(($COLUMNS - 12))
WCOL=$(($COLUMNS - 30))

# Set Cursur Position Commands, used via echo -e
SET_COL="\\033[${COL}G"
SET_WCOL="\\033[${WCOL}G"
CURS_UP="\\033[A"

# Set color commands, used via echo -e
NORMAL="\\033[0;39m"
SUCCESS="\\033[1;32m"
WARNING="\\033[1;33m"
FAILURE="\\033[1;31m"

echo_ok()
{
	echo -e "$CURS_UP$SET_COL"["$SUCCESS""    OK    ""$NORMAL"]
}

echo_failure()
{
	echo -e "$CURS_UP$SET_COL"["$FAILURE""  FAILED  ""$NORMAL"]
}

echo_warning()
{
	echo -e "$CURS_UP$SET_WCOL$@$SET_COL"["$WARNING""   WARN   ""$NORMAL"]
}

echo_yes()
{
	echo -e "$CURS_UP$SET_COL"["$SUCCESS""    YES   ""$NORMAL"]
}

echo_no()
{
	echo -e "$CURS_UP$SET_COL"["$SUCCESS""    NO    ""$NORMAL"]
}

echo_loaded()
{
	echo -e "$CURS_UP$SET_COL"["$SUCCESS""  LOADED  ""$NORMAL"]
}

echo_not_loaded()
{
	echo -e "$CURS_UP$SET_COL"["$FAILURE""NOT LOADED""$NORMAL"]
}

print_error_msg()
{
	echo -e -n $FAILURE
	echo "****************************************************************"
	echo "* FAILURE. Something doesn't work here,                        *"
	echo "* last command gives me an error.. :-(                         *"
	echo "*                                                              *"
	echo "* Press Enter to continue..                                    *"
	echo "****************************************************************"
	echo -e -n $NORMAL
	read ENTER
}

CheckBinary()
{
	if [ -d $1 ];	then
		echo -e -n $FAILURE
		echo "Checking binary $1.."
		echo "$1 is a directory, not a binary. Cannot continue - EXITING."
		echo -e -n $NORMAL
		exit -1
	fi
	if [ ! -f $1 ];	then
		echo -e -n $FAILURE
		echo "Checking binary $1.."
		echo "$1 is not a valid file or not found. Cannot continue - EXITING."
		echo -e -n $NORMAL
		exit -1
	fi
	if [ ! -s $1 ];	then
		echo -e -n $FAILURE
		echo "Checking binary $1 (file size).."
		echo "$1 is not a valid file (zero size!!). Cannot continue - EXITING."
		echo -e -n $NORMAL
		exit -1
	fi
	if [ ! -x $1 ]; then
		echo -e -n $FAILURE
		echo "Checking permissions of binary $1 .."
		echo "$1 is not executable. Check permissions! Cannot continue - EXITING."
		echo -e -n $NORMAL
		exit -1
	fi
}

eval_retval()
{
	errval=$?
	if [ $errval = 0 ]; then
		print_status success
	else
		print_status failure
	fi
	return 0
}

print_status()
{
        if [ $# = 0 ]; then
                echo "Usage: $0 {success|warning|failure}"
                return 1
        fi
        case "$1" in
                success)
                        echo_ok
                ;;
                warning)
                        case "$2" in
                                running)
                                        echo_warning "Already running"
                                ;;
                                not_running)
                                        echo_warning "Not running"
                                ;;
                                not_available)
                                        echo_warning "Not available"
                                ;;
                        esac
                ;;
                failure)
                        echo_failure
                ;;
        esac
}

function Greeting ()
{
	clear
	echo -e -n $SUCCESS
	echo "=============================================================================="
	echo -e "THIS IS THE ""\\033[44m"" W_SCAN START SCRIPT ""\\033[49m$SUCCESS"" (see http://free.pages.at/wirbel4vdr)"
	echo ""
	echo "It will try the following:"
	echo ""
	echo "   step 1) checks wether vdr is running and if so, try to stop it"
	echo "   step 2) check wether your dvb driver is loaded and if not, load it"
	echo "   step 3) do a channel scan and create a vdr channels.conf"
	echo "   step 4) ask you, wether your vdr should be restarted"
	echo ""
	echo "PRESS ANY KEY TO CONTINUE OR CTRL+C TO EXIT"
	echo "=============================================================================="
	echo -e -n $NORMAL
	read
}



function StopVDR ()
{
  echo "Checking wether Video Disk Recorder software is stopped..."
  if [ "$(ps -A | grep vdr)" != "" ]; then
	echo_no
	echo -e -n $FAILURE
	echo "****************************************************************"
	echo "*                                                              *"
	echo "* W_SCAN CANNOT CONTINUE WHILE VDR IS RUNNING.                 *"
	echo "* Should I try to stop vdr for you? [y/n]                      *"
	echo "*                                                              *"
	echo "****************************************************************"
	echo -e -n $NORMAL
	read RESPONSE
	if [ "$RESPONSE" != "y" ]; then
		echo "OKAY. Exiting w_scan start script."
		sleep 2
		exit -1
        else
		clear
		echo "Trying to stop vdr..."
		echo "Checking for ct-vdr style startscript.."
		if [ -e /etc/init.d/vdr ]; then			# c't-vdr
			echo_yes
			$(/etc/init.d/vdr stop)
		else
			echo_no
		fi
		echo "Checking for linvdr style startscript.."
		if [ -e /etc/init.d/runvdr ]; then		# linvdr
			echo_yes
			$(/etc/init.d/runvdr stop)
			$(/etc/init.d/runvdr loaddriver)
		else
			echo_no
		fi
		echo "Checking for runvdr in /usr/local/bin.."
		if [ -e /usr/local/bin/runvdr ]; then		# -|-
			echo_yes
			echo "   Checking wether /usr/local/bin/runvdr knows 'stop'..."
			VAR="$(cat /usr/local/bin/runvdr | grep 'stop)')"
			if [ "$VAR" != "" ]; then
				echo_yes
				$(/usr/local/bin/runvdr stop)
			else
				echo_no
			fi
		else
			echo_no
		fi
		echo "Checking for runvdr in /usr/bin.."
		if [ -e /usr/bin/runvdr ]; then			# -|-
			echo_yes
			echo "   Checking wether this /usr/bin/runvdr knows 'stop'..."
			VAR="$(cat /usr/bin/vdr | grep 'stop)')"
			if [ "$VAR" != "" ]; then
				echo_yes
				$(/usr/bin/runvdr stop)
			else
				echo_no
			fi
		else
			echo_no
		fi
		if [ "$(ps -A | grep vdr)" != "" ]; then 	# last Chance, but unusual system anyway..
			echo "No stop script found - using killall.."
			KILLALL=$(/usr/bin/which killall)
			$($KILLALL -9 vdr 2>&1 > /dev/null)
			$($KILLALL -9 runvdr 2>&1 > /dev/null)
			sleep 3
			if [ "$(ps -A | grep vdr)" != "" ]; then 	# we should re-check here
			    echo_failure
			    echo "VDR is running and cannot be stopped - giving up."
			    exit -1
			else
			    echo_ok
			fi			
		fi
	sleep 3	# waiting until process was stopped
	fi
  else
  	echo_ok
  fi
}


function StartVDR ()
{
    echo -e -n $SUCCESS
    echo "****************************************************************"
    echo "*                                                              *"
    echo "* All is done now.                                             *"
    echo "* Should I try to restart vdr for you? [y/n]                   *"
    echo "*                                                              *"
    echo "****************************************************************"
    echo -e -n $NORMAL
    read RESPONSE
	if [ "$RESPONSE" != "y" ]; then
		echo -n -e "\\033[1;34m"
		echo ""
		echo "GOODBYE! Exiting now."
		echo ""
		echo -e -n $NORMAL
		exit 0
        else
		if [ -e /etc/init.d/vdr ]; then			# c't-vdr
			$(/etc/init.d/vdr start)
		fi
		if [ -e /etc/init.d/runvdr ]; then		# linvdr
			$(/etc/init.d/runvdr start)	
		fi
		if [ -e /usr/local/bin/runvdr ]; then		# -|-
			echo  "   Checking wether /usr/local/bin/runvdr knows 'start'.."
			VAR="$(cat /usr/local/bin/runvdr | grep 'start)')"
			if [ "$VAR" != "" ]; then
				echo_yes
				$(/usr/local/bin/runvdr start)
			else
				echo_no
			fi

		fi
		if [ -e /usr/bin/runvdr ]; then			# -|-
			echo "   Checking wether this /usr/bin/runvdr knows 'start'..."
			VAR="$(cat /usr/bin/runvdr | grep 'start)')"
			if [ "$VAR" != "" ]; then
				echo_yes
				$(/usr/bin/runvdr start)
			else
				echo_no
			fi

		fi
		echo -n -e "\\033[1;34m"
		echo ""
		echo "On most systems vdr should run now - if not, reboot."
		echo "GOODBYE! Exiting now."
		echo ""
		echo -e -n $NORMAL
	fi
}


function LoadDriver ()
{

	# I don't actually know which Modules are *really* needed here
	# may be i should add some more here?
	# dvb_ttpci and budget* loads mosts drivers,
	# anyway - frontends cinergy T, Airstar2/Avermedia771 and tda10045/46
	# have to be loaded manually.
	# Urgently waiting for response from users, see email on the top..
	# 20060710 wirbel


	MODULES_TO_LOAD="dvb_ttpci \
			budget_ci budget_av budget_ci budget \
			cinergyT2 \
			b2c2_flexcop_pci \
			tda1004x"
			
	for M in $MODULES_TO_LOAD; do
		MODULES=$(lsmod)
		echo "Checking for kernel module $M.."
		if [ "$(echo $MODULES | grep $M)" == "" ]; then
			echo_not_loaded
			echo "Loading module $M..."
			modprobe $M
			eval_retval
		else
		    echo_loaded
		fi
	done
}

function DoScan ()
{ 
	if [ -e channels.conf-$DATE ]; then
		rm -f channels.conf-$DATE
	fi
	touch channels.conf-$DATE
	echo -e -n $SUCCESS
	echo "****************************************************************"
	echo "*                                                              *"
	echo "* Channel scan will take some minutes - have a cup of coffee.. *"
	echo "* PRESS ANY KEY TO CONTINUE OR CTRL+C TO EXIT.                 *"
	echo "*                                                              *"
	echo "****************************************************************"
	echo -e -n $NORMAL
	read
	echo -e -n "\\033[1;34m"
	$(pwd)/w_scan >> channels.conf-$DATE 
	$(pwd)/w_scan -fc >> channels.conf-$DATE
	echo -e -n $NORMAL
}

function CopyConf ()
{
	if [ -s channels.conf-$DATE ]; then
		clear
		echo -e -n $SUCCESS
		echo "****************************************************************"
		echo "*                                                              *"
		echo "* w_scan is done.                                              *"
		echo -e "* The output file is called "$FAILURE"channels.conf-$DATE"$SUCCESS".            *"
		echo "* Should I copy this to default location for you? [y/n]        *"
		echo "*                                                              *"
		echo "****************************************************************"
		echo -e -n $NORMAL
		read RESPONSE
		if [ "$RESPONSE" != "y" ]; then
			echo "Copying channels.conf skipped - okay."
			echo "The channels.conf generated can be found at"
			echo -n -e "\\033[1;34m"
			echo "$(pwd)/channels.conf-$DATE"
			echo ""
			echo -e -n $NORMAL
		else
			if [ -d /etc/vdr ]; then
				mv /etc/vdr/channels.conf /etc/vdr/channels.conf-backup$DATE
				cp channels.conf-$DATE /etc/vdr/channels.conf
			fi
			if [ -d /var/lib/vdr ]; then
				mv /var/lib/vdr/channels.conf /var/lib/vdr/channels.conf-backup$DATE
				cp channels.conf-$DATE /var/lib/vdr/channels.conf
			fi			
		fi
        else
		clear
		echo -e -n $FAILURE
		echo "****************************************************************"
		echo "*                                                              *"
		echo "* Something went wrong. The channels.conf generated is *EMPTY*!*"
		echo "* To analyze your problem I recommend the command              *"
		echo "*    './w_scan 2>&1 | tee w_scan.log-dvbt &&                   *"
		echo "*     ./w_scan -fc 2>&1 | tee w_scan.log-dvbc'                 *"
		echo "*                                                              *"
		echo "* w_scan will report the problem into the logfiles             *"
		echo "* w_scan.log-dvbt and w_scan.log-dvbc.                         *"
		echo "*                                                              *"
		echo "* PRESS ANY KEY TO CONTINUE                                    *"
		echo "****************************************************************"
		echo -e -n $NORMAL
		read
	fi

}

# the program itself.
# init global vars here (if not avoidable..)
# and start functions
# --wirbel

CheckBinary "$W_SCAN"
Greeting
StopVDR
LoadDriver
DoScan
CopyConf
StartVDR


