/*
 * malloctest.c
 *
 * Responsible: Reto Baettig (baettig@scs.ch)
 *
 * History:	11-01-00 Created		rb
 */


#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <pthread.h>
#include <assert.h>
#include <asm/system.h>

#define NUM_THREADS 10

/* 
 * this array is not protected by mutexes. it does not need to 
 * be protected because we are only interested if the threads 
 * still do something or if they stopped
 */
long	 		th_req[NUM_THREADS] = {0, };

typedef struct mem_str {
	char *buf;
	int delete;
} mem_str;

void
Th_Delay(int dt)
{
	struct timeval intval;

	intval.tv_sec = dt/1000;
	intval.tv_usec = (dt % 1000) * 1000;
		      
	select(0, NULL, NULL, NULL, &intval);
}

void my_pthread_create( void * func, void *arg)
{ 	
	pthread_t x; 
	if (pthread_create(&x, NULL, func, arg)) {
			printf("pthread_create error\n"); 
			exit(-1);
	}
}

void Free(void *m)
{
	struct mem_str *mem=(struct mem_str *)m;
	
	while(1) {
		while (!mem->delete)
			Th_Delay(1);

		mb(); /* This is important to ensure that mem->buf 
			 has been written to memory yet */

		assert(mem->buf != NULL);
		assert(mem->delete);
		free(mem->buf);
		mem->buf = NULL;
		mem->delete = 0;
	}
}

#define MAX_LEN (1024*1024)
void DoTest(long Th_Num)
{
	struct mem_str mem;
	size_t len;

	mem.delete = 0;	
	mem.buf = NULL;
	my_pthread_create(Free, (void *)&mem);

	while(1) {
		len = (random()*(long long)MAX_LEN/RAND_MAX) + 1;

		mem.buf = malloc(len);
		assert(mem.buf != NULL);

		th_req[Th_Num]++;
	
		mem.delete = 1;
		
		while (mem.delete) 
			Th_Delay(1);
		
		mb(); /* This is important to ensure that mem->buf 
			 has been written to memory yet */

		assert(mem.buf == NULL);
		assert(mem.delete == 0);

	}	
}

int
main(void)
{
	int i;

	for (i = 0; i<NUM_THREADS; i++) {
		my_pthread_create(DoTest, (void *)(long)i);
	}

	while ( 1 ) {
		Th_Delay(1000);
		
		printf("Mallocs/Thread:"); 
		for (i=0; i<NUM_THREADS; i++) {
			printf("%4i ", th_req[i]);
			th_req[i]=0;
		}
		printf("\n");
	}

	return 0;
}
