
#if !REF_INLINE

#include "atomic.h"

bool refcount_inc_not_zero(atomic_t *r)
{
        unsigned int new, val = atomic_read(r);

        do {
                new = val + 1;

                if (!val)
                        return false;

                if (unlikely(!new))
                        return true;

        } while (!atomic_try_cmpxchg(r, &val, new));

	if (unlikely(new == UINT_MAX))
		ud2();

        return true;
}

void refcount_inc(atomic_t *r)
{
	if (!refcount_inc_not_zero(r))
		ud2();
}

#endif
