#include "tf.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <ext2fs/ext2fs.h>
#include <ext2fs/ext2_fs.h>

int count = 0;

void display_inode(struct ext2_inode *ind)
{
	printf("------------------------------\n");
	printf("mode = %d\n", ind->i_mode);
	printf("uid = %d\n", ind->i_uid);
	printf("size = %ld\n", ind->i_size);
	printf("atime = %ld\n", ind->i_atime);
	printf("ctime = %ld\n", ind->i_ctime);
	printf("mtime = %ld\n", ind->i_mtime);
	printf("dtime = %ld\n", ind->i_dtime);
	printf("gid = %d\n", ind->i_gid);
	printf("links_count = %d\n", ind->i_links_count);
	printf("blocks = %ld\n", ind->i_blocks);
	printf("flags = %ld\n", ind->i_flags);
}

int ext2_record_dfs(char *node, ext2_filsys fs, int fd)
{
	int rc;
	struct stat stbuf;
	DIR *d;
	struct dirent *dentry;
	errcode_t ret;
	strec tmp;

	rc = lstat(node, &stbuf);
	if (rc != 0)
	{
		printf("***Error in stating the file: %s\n", node);
		return -1;
	}

	ret = ext2fs_read_inode(fs, stbuf.st_ino, &tmp.ind);
	if (ret)
	{
		printf("Error in reading inode\n");
		return -2;
	}

	display_inode(&tmp.ind);
	printf("inode: ino = %lu\n", stbuf.st_ino);
	printf("node = %s\n", node);

	strcpy(tmp.node, node);
	tmp.ino = stbuf.st_ino;
	rc = write(fd, &tmp, sizeof(tmp));
	if (rc != sizeof(tmp))
	{
		printf("Partial/Failed write to state file\n");
		//return -2;	// should we return?
	}

	count++;
	if (S_ISDIR(stbuf.st_mode))
	{
		d = NULL;
		d = opendir(node);
		if (d == NULL)
		{
			printf("***Error opening directory %s\n", node);
			return -1;
		}

		dentry = readdir(d);
		while(dentry != NULL)
		{
			if (strcmp(dentry->d_name, ".") == 0 || strcmp(dentry->d_name, "..") == 0)
			{
				dentry = readdir(d);
				continue;
			}

			strcpy(tmp.node, node);
			strcat(tmp.node, "/");
			strcat(tmp.node, dentry->d_name);
			
			ext2_record_dfs(tmp.node, fs, fd);
			dentry = readdir(d);
		}

		rc = closedir(d);
		if (rc == -1)
		{
			printf("***Error closing directory\n");
			//return -1;	// should we return?
		}
	}

	return 0;
}

int ext2_record(char *dev_name, char *mountpt, char *statefile)
{
	int fd, ret;
	errcode_t rc;
	ext2_filsys fs;

	long int flags = EXT2_FLAG_FORCE;
	int sb = 0;
	int blksz = 0;

	fd = open(statefile, O_WRONLY | O_CREAT | O_SYNC);
	if (!fd)
	{
		printf("Error opening state file\n");
		return -2;
	}

	rc = ext2fs_open(dev_name, flags, sb, blksz, unix_io_manager, &fs);
	if (rc)
	{
		printf("Error in opening file system\n");
		return -2;
	}

	ret = ext2_record_dfs(mountpt, fs, fd);
	
	ext2fs_close(fs);
	close(fd);

	fd = open("icount", O_WRONLY | O_CREAT | O_SYNC);
	if (!fd)
	{
		printf("Error opening icount file\n");
		return -2;
	}

	ret = write(fd, &count, sizeof(count));
	if (ret != sizeof(count))
	{
		printf("Partial/Failed write to icount file\n");
		return -2;
	}

	close(fd);

	return 0;
}

int main(int argc, char *argv[])
{
	int rc;
	
	if (argc < 5)
	{
		printf("Usage: %s <device name> <mount point> <fstype> <state file>\n", argv[0]);
		printf("\tdevice name = name of the device/name of file system image whose state is to be recorded\n");
		printf("\tmount point = mount point of the named device\n");
		printf("\tfstype = file system type on the named device\n");
		printf("\tstate file = name of the file where the state information is to be stored\n");

		return -1;
	}

	if (strcmp(argv[3], "ext2") == 0)
	{
		rc = ext2_record(argv[1], argv[2], argv[4]);
		return count;
	}
	else
	{
		printf("Unrecognised file system type\n");
		return -1;
	}
}
