#include "tf.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
	int rc, i;
	int iter, fd;
	float avg;
	char tmp[50], str[50];
	reportrec rec;
	unsigned long lost_cnt, meta_corr_cnt;

	if (argc < 7)
	{
		printf("Usage: %s <fs type> <fs image name> <fs image size> <fs block size> <iterations> <cummulative duration>\n", argv[0]);
		printf("\tfs type = file system type (ext2)\n");
		printf("\tfs image name = name of file system image\n");
		printf("\tfs image size = size of the file system image (in KB)\n");
		printf("\tfs block size = block size to be used for file system image (in B)\n");
		printf("\titerations = number of iterations to perform\n");
		printf("\tcummulative duration = sum of time spent in the repair and recovery phase\n");
		return -1;
	}

	iter = atoi(argv[5]);
	avg = (float)atoi(argv[6]) / (float)iter;
	printf("Average time taken for recovery (in seconds) = %f\n", avg);

	for (i = 0; i < iter; i++)
	{
		lost_cnt = meta_corr_cnt = 0;

		sprintf(str, "%d", i);
		strcpy(tmp, "report");
		strcat(tmp, str);

		fd = open(tmp, O_RDONLY);
		if (!fd)
		{
			printf("Error opening report%d file\n", i);
			break;
		}

		while(1)
		{
			rc = read(fd, &rec, sizeof(rec));
			if (rc != sizeof(rec))
			{
				//printf("***Error in reading report%d file\n", i);
				break;
			}

			if (rec.flag == 0)
			{
				lost_cnt++;
			}
			else
			{
				meta_corr_cnt++;
			}
		}

		close(fd);

		printf("Number of files lost at the end of %d iteration = %lu\n", i, lost_cnt);
		printf("Number of files with metadata corruption at the end of %d iteration = %lu\n", i, meta_corr_cnt);
	}

	return 0;
}
