#!/usr/bin/perl -w

use English;

$runs = 10000;
$tiny_compress = 0;
$tiny_decompress = 0;
$tiny_rcompress = 0;
$tiny_rdecompress = 0;
$tiny_combined = 0;
$tiny_comp = 0;
$tiny_decomp = 0;
$tiny_rcomp = 0;
$tiny_rdecomp = 0;
$full_compress = 0;
$full_decompress = 0;
$full_rcompress = 0;
$full_rdecompress = 0;
$full_combined = 0;
$full_comp = 0;
$full_decomp = 0;
$full_rcomp = 0;
$full_rdecomp = 0;

for $i (1..$runs) {
    $run = `./tinytest`;
    @lines = split( /\n/, $run );
    for($c = 0; $c < 4; $c += 1) {
        if( $lines[$c] =~ /.*\sC: (\d*).*/ ) {
	    $tiny_compress += $1;
	} elsif( $lines[$c] =~ /.*\sD: (\d*).*/ ) {
	    $tiny_decompress += $1;
	} elsif( $lines[$c] =~ /.*\sRC: (\d*).*/ ) {
	    $tiny_rcompress += $1;
	} elsif( $lines[$c] =~ /.*\sRD: (\d*).*/ ) {
	    $tiny_rdecompress += $1;
	} else {
	    print "Unable to match input data to potential rules!\n";
	    print "Input in question:\n";
	    print $run;
	    print "Exiting Now\n";
	    exit(1);
	}
    }
}

for $i (1..$runs) {
    $run = `./fulltest`;
    @lines = split( /\n/, $run );
    for($c = 0; $c < 4; $c += 1) {
        if( $lines[$c] =~ /.*\sC: (\d*).*/ ) {
	    $full_compress += $1;
	} elsif( $lines[$c] =~ /.*\sD: (\d*).*/ ) {
	    $full_decompress += $1;
	} elsif( $lines[$c] =~ /.*\sRC: (\d*).*/ ) {
	    $full_rcompress += $1;
	} elsif( $lines[$c] =~ /.*\sRD: (\d*).*/ ) {
	    $full_rdecompress += $1;
	} else {
	    print "Unable to match input data to potential rules!\n";
	    print "Input in question:\n";
	    print $run;
	    print "Exiting Now\n";
	    exit(1);
	}

    }
}

$tiny_combined = ( $tiny_compress + $tiny_decompress + 
		   $tiny_rcompress + $tiny_rdecompress ) / $runs;
$tiny_comp = $tiny_compress / $runs;
$tiny_decomp = $tiny_decompress / $runs;
$tiny_rcomp = $tiny_rcompress / $runs;
$tiny_rdecomp = $tiny_rdecompress / $runs;

$full_combined = ( $full_compress + $full_decompress + 
		   $full_rcompress + $full_rdecompress ) / $runs;
$full_comp = $full_compress / $runs;
$full_decomp = $full_decompress / $runs;
$full_rcomp = $full_rcompress / $runs;
$full_rdecomp = $full_rdecompress / $runs;

$oper = (($full_combined - $tiny_combined)/$full_combined) * 100;
$comp = (($full_comp - $tiny_comp)/$full_comp) * 100;
$decomp = (($full_decomp - $tiny_decomp)/$full_decomp) * 100;
$rcomp = (($full_rcomp - $tiny_rcomp)/$full_rcomp) * 100;
$rdecomp = (($full_rdecomp - $tiny_rdecomp)/$full_rdecomp) * 100;

print "$runs run averages:\n";
print "\'Tiny LZO\':\n";
print "\tCombined: $tiny_combined usec\n";
print "\tCompression: $tiny_comp usec\n";
print "\tDecompression: $tiny_decomp usec\n";
print "\tRandom Data Compression: $tiny_rcomp usec\n";
print "\tRandom Data Decompression: $tiny_rdecomp usec\n";
print "\'miniLZO\':\n";
print "\tCombined: $full_combined usec\n";
print "\tCompression: $full_comp usec\n";
print "\tDecompression: $full_decomp usec\n";
print "\tRandom Data Compression: $full_rcomp usec\n";
print "\tRandom Data Decompression: $full_rdecomp usec\n";

print "Percentages (calculated as: ((full - tiny)/full)*100):\n";
print "Overall (combined totals): Tiny is";
if( $oper < 0 ) {
    $k = 0-$oper;
    printf " %.2f %% slower\n", $k;
} else {
    printf " %.2f %% faster\n", $oper;
}
print "Compression: Tiny is";
if( $comp < 0 ) {
    $k = 0-$comp;
    printf " %.2f %% slower\n", $k;
} else {
    printf " %.2f %% faster\n", $comp;
}
print "Decompression: Tiny is";
if( $decomp < 0 ) {
    $k = 0-$decomp;
    printf " %.2f %% slower\n", $k;
} else {
    printf " %.2f %% faster\n", $decomp;
}
print "Random Compression: Tiny is";
if( $rcomp < 0 ) {
    $k = 0-$rcomp;
    printf " %.2f %% slower\n", $k;
} else {
    printf " %.2f %% faster\n", $rcomp;
}
print "Random Decompression: Tiny is";
if( $rdecomp < 0 ) {
    $k = 0-$rdecomp;
    printf " %.2f %% slower\n", $k;
} else {
    printf " %.2f %% faster\n", $rdecomp;
}
