#!/usr/bin/env perl

use IO::Handle;

open(SI, "+<", "/sys/kernel/debug/sysfs-interpreter")
    or die "failed to open sysfs-interpreter file\n";
SI->autoflush(1);

STDOUT->autoflush(1);

sub catch_zap {
    # noop
}
$SIG{INT} = \&catch_zap;

while (<STDIN>) {
    my $buf;
    my $line = $_;
    my $rc_min = 0;
    my $rc_max = 65536;

    $line =~ s/^\s*(.*)[\s\n]*/\1/;
    $line =~ s/([^\#]*)\#.*/\1/;
    next if (length($line) == 0);

    if ($line =~ /^f\s+.*$/) {
	$rc_min = -65536;
	$line =~ s/^f\s(.*)$/\1/;
    } elsif ($line =~ /^F\s+.*$/) {
	$rc_min = -65536;
	$rc_max = -1;
	$line =~ s/^F\s(.*)$/\1/;
    } elsif ($line =~ /^1\s+.*$/) {
	$rc_min = 1;
	$line =~ s/^1\s(.*)$/\1/;
    } elsif ($line =~ /^0\s+.*$/) {
	$rc_max = 0;
	$line =~ s/^0\s(.*)$/\1/;
    }

    $line =~ s/^\s*(\S.*)\s*/\1/;
    length($line) != 0 || die ("parse error \"$_\"");

    if ($line =~ s/^wait(|\s+(.*))$/\2/) {
	print "$line (^C to continue)";
	sleep;
	print "\n";
	next;
    }

    seek(SI, 0, 0);
    print SI "$line" or die "command \"$line\" failed ($!)\n";
    read(SI, $buf, 64, 0) or die "failed to read command result \"$line\" ($!)\n";

    print("command \"$line\" : result=$buf");

    die "unexpected result, aborting...\n"
	if ($buf < $rc_min || $buf > $rc_max);
}

exit 0;
