#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/poll.h>
#include <sys/socket.h>

#define BUF_LEN 0x200
#define MICRO 1e6

#define ERRORS(s)        \
  {                      \
    fprintf(stderr, "Error from line %d, file %s, call %s, (%s)\n", \
    __LINE__, __FILE__, (s), strerror(errno));                      \
    exit(EXIT_FAILURE);  \
  } 

int main (void);

int main()
{
    char buf[BUF_LEN];
    size_t len;
    int sp[2];
    struct timeval tv;
    struct pollfd pfd;
    double start, stop, total;
 
    if(socketpair(PF_UNIX, SOCK_STREAM, 0, sp) < 0)
        ERRORS("socketpair");
    switch(fork())
    {
    case 0:
        if(close(STDIN_FILENO))
            ERRORS("close");
        if(close(STDOUT_FILENO))
            ERRORS("close");
        if(close(STDERR_FILENO))
            ERRORS("close");
        if(dup2(sp[1], STDIN_FILENO) < 0)
            ERRORS("dup2");
        if(dup2(sp[1], STDOUT_FILENO) < 0)
            ERRORS("dup2");
        if(dup2(sp[1], STDERR_FILENO) < 0)
            ERRORS("dup2");
        if(sp[1] > STDERR_FILENO)
        {
            if(close(sp[1]))
                ERRORS("close");
        }
        for(;;)
        {
            pfd.fd      = STDIN_FILENO;
            pfd.events  = POLLIN;
            pfd.revents = 0;
            if(poll(&pfd, 1, -1) < 0)
                ERRORS("poll");
            if(pfd.events & POLLIN)
            {
                if((len = read(STDIN_FILENO, buf, BUF_LEN)) < 0)
                    ERRORS("read");
                if(write(STDOUT_FILENO, buf, len) != (int) len)
                    ERRORS("write");
            }
        }
        break;
    case -1:
        ERRORS("fork");
    default:
        for(;;)
        {
            (void)gettimeofday(&tv, NULL);
            start  = (double) tv.tv_sec * MICRO;
            start += (double) tv.tv_usec;
            if(write(sp[0], buf, BUF_LEN) != BUF_LEN)
                ERRORS("write");
            pfd.fd      = sp[0];
            pfd.events  = POLLIN;
            pfd.revents = 0;
            if(poll(&pfd, 1, -1) < 0)
                ERRORS("poll");
            if(pfd.events & POLLIN)
            {
                if((len = read(sp[0], buf, BUF_LEN)) < 0)
                    ERRORS("read");
            }
            (void)gettimeofday(&tv, NULL);
            stop  = (double) tv.tv_sec * MICRO;
            stop += (double) tv.tv_usec;
            total = stop - start;
            fprintf(stdout, "%f bytes / us\n", (double) BUF_LEN * 2 / total);
        }
    }
    return 0;
}

