


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <signal.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/wait.h>


#define FLEN 0x00800000

#define ERRORS(s) \
do { fprintf(stderr, "Error from line %d, file %s, (%s)\n", \
    __LINE__,__FILE__,strerror(errno)); \
    } while (0)

//
//    Write the file in an obviously-correct way.
//
void writer(int fd)
{
    char *buf, *run;
    int len, ret;
    if((buf = malloc(FLEN)) == NULL)
        ERRORS("malloc");
    len = FLEN;
    run = buf;
    while(len)
    {
        if((ret = write(fd, run, (size_t) len)) <= 0)
            ERRORS("write");
        len -= ret;
        run += ret;
    }
    free(buf);
}
//
//    Read the file in an obviously-correct way.
//
void reader(int fd)
{
    char *buf, *run;
    int len, ret;
    (void)lseek(fd, 0, SEEK_SET);		
    if((buf = malloc(FLEN)) == NULL)
        ERRORS("malloc");
    len = FLEN;
    run = buf;
    while(len)
    {
        if((ret = read(fd, run, (size_t) len)) <= 0)
            ERRORS("read");
        len -= ret;
        run += ret;
    }
    free(buf);
}
//
//   Create the file in an obviously-correct way.
//
int creater(const char *fname)
{
    int ret;
    if((ret = open(fname, O_RDWR|O_CREAT|O_TRUNC, 0644)) < 0)
        ERRORS("open");
    return ret;
}
//
//   Delete the file in an obviously-correct way.
//
void deleter(const char *fname)
{
    if(unlink(fname) < 0)
        ERRORS("unlink");
}
//
//   Get child return-status in an obviously-correct way.
//
void reaper(int sig)
{
    while(wait3(&sig, WNOHANG, NULL) > 0)
        ;
}

int main()
{
    char fname[0x10];
    int fd, i;
    pid_t pid;
    (void)signal(SIGCHLD, reaper);
    pid = 0;
    for(i= 0; i < 0x100; i++)
    {
        switch((pid = fork()))
        {
        case 0:			// Child
            sprintf(fname, "File.%04x", i);		// Make file-name
            fd = creater(fname);			// Create file
            writer(fd);					// Write file
            if(fsync(fd))				// Sync
                ERRORS("fsync");
            (void)usleep(rand() & 0x1ff);		// Let others catch us
            reader(fd);					// Read file
            (void)usleep(rand() & 0x1ff);		// Let others catch us
            if(close(fd))				// Close
                ERRORS("close");
            (void)usleep(rand() & 0x1ff);		// Let others catch us
            deleter(fname);				// Delete file
            exit(EXIT_SUCCESS);
        case -1:
            ERRORS("fork");
       default:
           break;
        }
    }
    (void)waitpid(pid, &i, 0);		// Wait for the last child	
    return 0;
}

