#include <math.h>
#include <stdio.h>
#include "mv.h"

void mv_init(struct mean_variance *mv)
{
	mv->n = 0;
	mv->mean = 0.0;
	mv->m2 = 0.0;
	mv->min = 0;
	mv->max = 0;
}

void mv_update(struct mean_variance *mv, uint64_t X)
{
	double x = (double)X;
	double delta;

	if (mv->n == 0) {
		mv->min = X;
		mv->max = X;
	} else {
		if (X < mv->min)
			mv->min = X;
		if (X > mv->max)
			mv->max = X;
	}
	mv->n++;
	delta = x - mv->mean;
	mv->mean += delta / mv->n;
	mv->m2 += delta * (x - mv->mean);
}

void mv_print(struct mean_variance *mv)
{
	double v = mv->m2 / (mv->n - 1);

	fprintf(stderr,
		"%f +- %f\t%llu-%llu\t\t%u\n",
		mv->mean, sqrt(v), (unsigned long long)mv->min, (unsigned long long)mv->max, mv->n);
}
