//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//       Copyright(c) 2004, 2005,  Analogic Corporation.
//       This program may be distributed under the GNU Public License
//       version 2, as published by the Free Software Foundation, Inc.,
//       59 Temple Place, Suite 330 Boston, MA, 02111.
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <asm/dma.h>
#include "config.h"                     // Local configuration
#define DEREF(x) #x
#define MKSTR(x) DEREF(x)
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  The top-level object that gets allocated once, when the module is
//  installed.
//
struct INFO {
    struct file_operations fa;          // Kernel connection
    struct semaphore dev_sem;
    int big_stack[0x4000];		// Where we put the stack
    int sp;
    };
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
const char devname[]="Analogic "MKSTR(MODNAME);
MODULE_AUTHOR("Analogic Corp <rjohnson@analogic.com>");
static struct INFO *info;

extern void set_new_stack(void *);	// In stack.S
extern void restore_stack(void *);	// In stack.S

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//   Control interface.
//   Test setting up and then restoring a new stack.
//
static int32_t ioctl(struct inode *ip, struct file *fp, uint32_t cmd, unsigned long arg)
{
    down(&info->dev_sem);
    set_new_stack(&info->sp);		// Set up new stack
    printk("Doing something scary on the new stack!!\n");
    {
        char foo[0x1000];		// Note: New program unit
        memset(foo, 0x00, sizeof(foo));	// Write this stack-data
        printk("Actually survived!\n");	// Make function call
    }
    restore_stack(&info->sp);		// Restore old stack
    up(&info->dev_sem);
    return 0;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//   This opens the device for access. This probably will happen only once
//   in the 'real world'.
//
static int32_t open(struct inode *inp, struct file *fp)
{
    down(&info->dev_sem);                               // Acquire resource
    up(&info->dev_sem);                                 // Release resource
    return 0;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//   This closes the device access. This probably will never happen
//   in the 'real world'.
//
static int32_t close(struct inode *inp, struct file *fp)
{
    down(&info->dev_sem);                               // Acquire resource
    up(&info->dev_sem);                                 // Release resource
    return 0;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//   Initialize the module and return 0 if everything is okay.
//   Return a negative error-code if not.
//
static int32_t __init startup()
{
    int32_t ret;
    if((info = kmalloc(sizeof (struct INFO), GFP_ATOMIC)) == NULL)
    {
        printk(KERN_ALERT"%s : Can't allocate memory\n", devname);
        return -ENOMEM;
    }
    memset(info, 0x00, sizeof(struct INFO));
    info->fa.owner   = THIS_MODULE;
    info->fa.open    = open;
    info->fa.ioctl   = ioctl;
    info->fa.release = close;
    init_MUTEX(&info->dev_sem);
    if((ret = register_chrdev(MAJOR_NR, devname, &info->fa)) < 0)
    {
        printk(KERN_ALERT"%s : Can't register major number %d\n",
                          devname, MAJOR_NR);
        return ret;
    }
    printk(KERN_INFO"%s : Initialization complete\n", devname);
    return 0;
}
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//  Cleanup the module in preparation for removal.
//
static void quit()
{
    int32_t ret;
    if((ret = unregister_chrdev(MAJOR_NR, devname)) < 0)
    {
        printk(KERN_ALERT"%s : Can't unregister major number %d (%d)\n",
                               devname, MAJOR_NR, ret);
        return;
    }
    kfree(info);
    printk(KERN_INFO"%s : Module removed\n", devname);
}
module_init(startup);           // Macro is now considered mandatory
module_exit(quit);              // Macro is now considered mandatory
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

