/*
 *   Copyright(c)   2004   Analogic Corporation
 *
 *   This program may be distributed under the GNU Public License
 *   version 2, as published by the Free Software Foundation, Inc.,
 *   59 Temple Place, Suite 330 Boston, MA, 02111.
 *
 *   File chktrue.c             Created 12-MAY-2004     Richard B. Johnson
 *
 *   Trivial program used to obtain the numerical value of
 *   TRUE and FALSE at compile-time. The kernel doesn't have the
 *   stdbool.h file header.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

static const char fname[]="bool.h";

int main(int args, char *argv[])
{
    FILE *file;
    (void)unlink(fname);                // Implimentation error with "w+"
    if((file = fopen(fname, "w")))
    {
        fprintf(file, "//\n// Created by %s\n", argv[0]);
        fprintf(file, "// All edits will be lost\n//\n");
        fprintf(file, "#ifndef _BOOL_H_\n");
        fprintf(file, "#define _BOOL_H_\n");
        fprintf(file, "#define TRUE  %d\n", (int)(file != NULL));
        fprintf(file, "#define FALSE %d\n", (int)(file == NULL));
        fprintf(file, "#endif\n");
        fclose(file);
    }
    else
    {
        fprintf(stderr, "Can't create file, %s\n", fname);
        exit(EXIT_FAILURE);
    } 
    return 0; 
}
