/*
 * sig_exec_target.c: target for exec() from signal-exec() races.
 *
 * Usage:
 * 	./sig_exec_target [ pathname [ offset ] ]
 *
 * where "pathname" is the path of the file to mmap(), and offset
 * is the address within that file of the int to set to 1.
 * If "offset" is omitted, the value of 0 is assumed.  If "pathname"
 * is omitted, no file is mapped.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright (C) IBM Corporation, 2005
 *
 * Author: Paul E. McKenney <paulmck@us.ibm.com>
 */

#include "steamroller.h"

void usage(int argc, char *argv[])
{
	int i;

	fprintf(stderr, "Usage: %s [ path [ offset ] ]\n", argv[0]);
	fprintf(stderr, "argc = %d\n", argc);
	for (i = 0; i < argc; i++) {
		fprintf(stderr, "argv[%d] = :%s:\n", i, argv[i]);
	}
	exit(-1);
}

int main(int argc, char *argv[])
{
	char *endptr;
	int errno_sav;
	int fd;
	unsigned long offset = 0;
	char *p;

	if (argc > 3) {
		usage(argc, argv);
	}
	if (argc >= 2) {
		fd = open(argv[1], 0);
		if (fd == -1) {
			errno_sav = errno;
			(void)fprintf(stderr, "arg 1 error: \"%s\" ", argv[1]);
			errno = errno_sav;
			perror("");
			usage(argc, argv);
		}
		if (argc >= 3) {
			offset = strtoul(argv[2], &endptr, 0);
			if ((argv[2][0] == '\0') || (*endptr != '\0')) {
				(void)fprintf(stderr,
					      "arg 2 non-integral: \"%s\"\n",
					      argv[2]);
				usage(argc, argv);
			}
		}
		p = (char *)mapmem(offset + sizeof(int), fd);
		*(int *)(p + offset) = 1;
	}
	exit(0);
}
