#include <stdlib.h>
#include <stdio.h>

int main (int argc, char* argv[])
{
	int num_kb;
	size_t num_bytes;
	size_t num_ints;
	size_t num_entries;
	size_t iter_per_dot;
	size_t i;
	size_t *mem;
	
	if (argc == 2) {
		char *end = NULL;
		num_kb=strtoull(argv[1], &end, 0);
	} else {
		printf("Usage: qtest [num_kb]\n");
		return(1);
	}

	num_bytes=1024*((size_t)num_kb);
	num_entries=num_bytes/sizeof(size_t);
	
	if(!(mem=malloc(num_bytes))) {
		printf("Could not malloc memory\n");
		return(1);
	}

	printf("\n  Writing memory");

	iter_per_dot=num_entries/50;

	for(i=0;i<num_entries;i++){
		mem[i]=i;
		if ((i % iter_per_dot)==0) {printf ("."); fflush(stdout);}
	}
	
	printf("\nVerifying memory");
	for(i=0;i<num_entries;i++){
		if(mem[i]!=i) {
			printf ("\nVerify failed!\n");
			return 1;
		}
		if ((i % iter_per_dot)==0) {printf ("."); fflush(stdout);}
	}

	printf ("\nAll OK!\n");	
		
	return 0;
}

		


	



	
		

