#!/bin/bash

# use_compcache (run as *root*)
# - Loads compcache and related modules.
# - Sets up swap device.
#
# Usage: use_compcache.sh <size in KB>
#

SIZE_KB="$1"
TEST_KB="$2"
TEST_CYCLE="$3"

MEM_SIZE_KB=`grep MemTotal: /proc/meminfo  | sed s/[^0-9]//g`

if [ -z "$SIZE_KB" ]; then
	echo "compcache size not given. Using 100% of RAM."
	SIZE_KB=$((10*MEM_SIZE_KB/10))
fi

if [ -z "$TEST_KB" ]; then
	echo "Test size not given. Using 150% of RAM."
	TEST_KB=$(((15*MEM_SIZE_KB)/10))
fi

if [ -z "$TEST_CYCLE" ]; then
	echo "Number of Cycles not given. Using 10."
	TEST_CYCLE=10
fi

echo MEM_SIZE_KB: $MEM_SIZE_KB
echo SIZE_KB: $SIZE_KB
echo TEST_KB: $TEST_KB
echo TEST_CYCLE: $TEST_CYCLE:

if [ "$SIZE_KB" -gt 0 ]
then
	sudo sh use_compcache.sh "$SIZE_KB"
else
	sudo sh unuse_compcache.sh
fi

rm a.out
gcc qtest.c
i=0
while [ $i -lt "$TEST_CYCLE" ]
do
	i=$(($i+1))
	if ./a.out "$TEST_KB" 
	then
		true
	else
		sudo sh unuse_compache.sh
		exit
	fi
done

sudo sh unuse_compache.sh

exit 

MEMTESTER=memtester-4.0.8
if [ ! -e $MEMTESTER ]
	echo no memtester directory
	if [ ! -e $MEMTESTER.tar.gz ]
	then
		wget -c http://pyropus.ca/software/memtester/old-versions/$MEMTESTER.tar.gz
	fi
	tar -zxf $MEMTESTER.tar.gz
	cd $MEMTESTER

		
  


 
