// This is a small server that prints everything it listens.
import java.io.*; 
import java.net.*; 
class WebPrintConnection extends Thread { 
	private Socket socket; 
	private BufferedReader in; 
	private PrintWriter out; 
	private PrintWriter printer;
	private String raddr;
	public WebPrintConnection(Socket s,String printerfile) throws IOException { 
		socket = s; in = new BufferedReader( new InputStreamReader( socket.getInputStream())); 
		out = new PrintWriter( new BufferedWriter( new OutputStreamWriter( socket.getOutputStream())), true);
		printer = new PrintWriter( new BufferedWriter(  new FileWriter(printerfile)));
		start(); // Calls run() 
 	} 
 	public void run() { 
 		try { 
 			while (true) { 
 				String str = in.readLine();
		 		if (str.equals("+++END+++")) break;
				printer.println(str);
				System.out.println(str); 
	 		}
	 		printer.close();
	 		System.out.println("ENDING");
	 	} catch (IOException e) {
	 	} finally {
	 		try {
	 			socket.close();
	 			printer.close();
	 		} catch(IOException e) {}
	 	}
	 }
}
public class WebPrint {
	public static void main(String[] argv)
			throws IOException {
		ServerSocket s = new ServerSocket(8080);
//		ServerSocket s2 = new ServerSocket(8081);
//		FileWriter lp1= new FileWriter("lpt1:");
//		FileWriter lp2= new FileWriter("lpt2:");
		
		System.out.println("Server Started");
		try {
			while(true) {
				// Blocks until a connection occurs:
				Socket socket = s.accept(); 
				try {
					new WebPrintConnection(socket,"test");
				} catch(IOException e) {
					// If it fails, close the socket,
					// otherwise the thread will close it:
					socket.close();
				}
			}
		} finally {
			s.close();
		}
	}
}
