#include <time.h>
#include <unistd.h>
#include <stdio.h>
// FROM #include "/usr/include/linux/time.h"
#define CLOCK_PERF 12

#define UNREFERENCED(x) ((x)=(x))

unsigned long long time_perf (void)
{
	unsigned long long t_sec, t_nsec;
	struct timespec ts;
	clock_gettime(CLOCK_PERF, &ts);

	t_sec = ts.tv_sec;
	t_nsec = ts.tv_nsec;
	return t_sec * 1000000000 + t_nsec;
}

unsigned long long time_monotonic (void)
{
	unsigned long long t_sec, t_nsec;
	struct timespec ts;
	clock_gettime(CLOCK_MONOTONIC, &ts);

	t_sec = ts.tv_sec;
	t_nsec = ts.tv_nsec;
	return t_sec * 1000000000 + t_nsec;
}

int main (int argc, char *argv[])
{
	unsigned long long tm[4], tp[4];

	UNREFERENCED(argc);
	UNREFERENCED(argv);

	tm[0] = time_monotonic (); tp[0] = time_perf ();
	sleep (1);
	tm[1] = time_monotonic (); tp[1] = time_perf ();

	tp[2] = time_perf(); tm[2] = time_monotonic ();
	sleep (2);
	tp[3] = time_perf(); tm[3] = time_monotonic ();

	printf ("Delta 1st sleep (1s)\n");
	printf ("MONOTONIC      t0 = %llu t1 = %llu, t1-t0 = %llu\n", tm[0], tm[1], tm[1]-tm[0]);
	printf ("PERF           t0 = %llu t1 = %llu, t1-t0 = %llu\n", tp[0], tp[1], tp[1]-tp[0]);
	printf ("\nDelta 2nd sleep (2s)\n");
	printf ("MONOTONIC      t2 = %llu t3 = %llu, t3-t2 = %llu\n", tm[2], tm[3], tm[3]-tm[2]);
	printf ("PERF           t2 = %llu t3 = %llu, t3-t2 = %llu\n", tp[2], tp[3], tp[3]-tp[2]);
	printf ("\nDelta between PERF & MONOTONIC for the 4 times taken\n");
	printf ("%llu %llu %llu %llu\n", tp[0]-tm[0], tp[1]-tm[1], tp[2]-tm[2], tp[3]-tm[3]);

	return 0;
}
