# @OSF_COPYRIGHT@
# COPYRIGHT NOTICE
# Copyright (c) 1990, 1991, 1992, 1993, 1994, 1996 Open Software Foundation, Inc.
# ALL RIGHTS RESERVED (DCE).  See the file named COPYRIGHT.DCE for
# the full copyright text.
# 
# HISTORY
# $Log: abbr_general_i.tcl,v $
# Revision 1.1.4.2  1996/03/11  02:35:32  marty
# 	Update OSF copyright years
# 	[1996/03/10  19:40:49  marty]
#
# Revision 1.1.4.1  1995/12/11  15:26:22  root
# 	Submit
# 	[1995/12/11  14:36:22  root]
# 
# Revision 1.1.2.4  1994/07/06  15:11:17  marrek
# 	July 1994 code drop.
# 	[1994/07/06  07:23:18  marrek]
# 
# Revision 1.1.2.3  1994/06/10  20:21:34  devsrc
# 	cr10872 - fixed copyright
# 	[1994/06/10  16:59:32  devsrc]
# 
# Revision 1.1.2.2  1994/05/11  10:34:50  marrek
# 	Updated.
# 	[1994/05/11  10:24:30  marrek]
# 
# Revision 1.1.2.1  1994/05/10  14:33:50  marrek
# 	Created in April 1994 submission.
# 	[1994/05/03  12:14:59  marrek]
# 
# $EndLog$
# 
# $RCSfile: abbr_general_i.tcl,v $ $Revision: 1.1.4.2 $ $Date: 1996/03/11 02:35:32 $
# 

#-----------------------------------------------------------------#
#                                                                 #
# Copyright (c) 1993 Siemens Nixdorf Informationssysteme AG       #
# All Rights Reserved                                             #
#                                                                 #
# Project     : Tester for GDS Control Program (gdscp)            #
# File Name   : abbr_general_i.tcl                             	  #
# Description : This file contains all the general test cases     #
#		for the invalid operations on the x500abbr object #
# Date        : February 1994                                     #
# Author      : B T Naik, SNI BU BA KP13, SISL India.             #
#                                                                 #
#-----------------------------------------------------------------#

proc abbr_general_01i {} {
    set test_case_name "abbr_general_01i"
    set command "x500abbr"
    set exp_result "Missing operation."
    set exp_error_code "GDSCP -706"
    run_testcase $test_case_name $command $exp_result $exp_error_code
}

proc abbr_general_02i {} {
    set test_case_name "abbr_general_02i"
    set command "x500abbr \"\""
    set exp_result "Unknown operation \"\"."
    set exp_error_code "GDSCP -705"
    run_testcase $test_case_name $command $exp_result $exp_error_code
}

proc abbr_general_03i {} {
    set test_case_name "abbr_general_03i"
    set command "x500abbr -pretty"
    set exp_result "Missing operation."
    set exp_error_code "GDSCP -706"
    run_testcase $test_case_name $command $exp_result $exp_error_code
}

proc abbr_general_04i {} {
    set test_case_name "abbr_general_04i"
    set command "x500abbr modify"
    set exp_result "Unknown operation \"modify\"."
    set exp_error_code "GDSCP -705"
    run_testcase $test_case_name $command $exp_result $exp_error_code
}

proc abbr_general_05i {} {
    set test_case_name "abbr_general_05i"
    set command "x500abbr quit"
    set exp_result "Unknown operation \"quit\"."
    set exp_error_code "GDSCP -705"
    run_testcase $test_case_name $command $exp_result $exp_error_code
}
