#ifndef SCBUF_H_INCLUDED
#define SCBUF_H_INCLUDED
/*
 *  Simple scattered buffer management for Linux SCSI.
 *
 *	The purpose of this simple buffer is to allow large buffering to 
 *	really work under Linux SCSI. Candidates for use of it are:
 *	- sg driver
 *	- mt driver
 *	- SCSI_IOCTL_SEND_COMMAND
 *
 *  Copyright (C) 1999, Gerard Roudier <groudier@club-internet.fr>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 as published 
 *  by the Free Software Foundation.
 */

#ifdef TESTING_FROM_USERLAND
#include <tstscbuf.h>
#else
#endif

/*
 *	Some redefines
 */
typedef struct scatterlist scatt_t;

/*
 *	Buffer structure
 */
typedef struct scbuf {
	int	order;		/* Order for page allocations */
	int	sgmax;		/* Max number of sg entries for this buffer */
	int	sgnbr;		/* Current number of allocated sg entries */
	scatt_t	sglist[1];	/* Shall be the last field of this structure */
				/* for the structure to be sized dynamically */
} scbuf_t;

/*
 *	Buffer functions
 *	See the C files for details of functions interface and how they 
 *	proceed.
 */
int scbuf_copy_in(void *kptr, void *uptr, int len);
int scbuf_copy_out(void *uptr, void *kptr, int len);
scbuf_t *scbuf_alloc(int osflags, int maxsg, int maxsize, int size);
void scbuf_free(scbuf_t *buf);
int scbuf_resize(int osflags, scbuf_t *buf, int size);
int scbuf_prepare_for_io(scatt_t **sgl, scbuf_t *buf, int size);

int scbuf_copy(int copy(void *to, void *from, int),
			scbuf_t *buf, int offs, char *uptr, int usize);

#define scbuf_copy_from_user(bp, uo, up, us) \
	scbuf_copy(scbuf_copy_in, (bp), (uo), (up), (us))

#define scbuf_copy_to_user(bp, uo, up, us) \
	scbuf_copy(scbuf_copy_out, (bp), (uo), (up), (us))

#endif /* SCBUF_H_INCLUDED */
