#define TESTING_FROM_USERLAND
#define DEBUG
#include <scbuf.h>

u_long copy_from_user(void *to, void *from, u_long size)
{
	memcpy(to, from, size);
	return 0;
}

u_long copy_to_user(void *to, void *from, u_long size)
{
	memcpy(to, from, size);
	return 0;
}

void *__get_free_pages(int osflags, int order)
{
	return malloc(PAGE_SIZE<<order);
}

void free_pages(void *m, int order)
{
	free(m);
}

#define MAX_KB 256

main(int argc, char **argv)
{
	scbuf_t *bp;
	int seed, tries, i, maxsg, maxsize, size, resize, iosize;
	int cpinsize, rest, cpoutsize;
	scatt_t *sglist;
	char *buf0, *buf1;

	tries	= argc > 1? atoi(argv[1]) : 1;
	seed	= argc > 2? atoi(argv[2]) : 1;
	
	srand(seed);
	buf0 = malloc(MAX_KB*1024);
	buf1 = malloc(MAX_KB*1024);

	for (i = 0; i < MAX_KB*1024; i++)
		buf0[i] = rand() & 0xff;

	for (i = 0; i < tries ; i++) {
		maxsg	= rand() % 100 + 1;
		maxsize	= (rand() % MAX_KB) * 1024;
		size	= maxsize / (rand() % 3 + 1);

		printf("[ALLOC    ----- maxsg=%d maxsize=%d size=%d -----]\n",
			maxsg, maxsize, size);
		bp = scbuf_alloc(0x123, maxsg, maxsize, size);
		if (!bp)
			continue;

		resize	= maxsize / (rand() % 3 + 1);
		printf("[RESIZE   ----- resize=%d -----]\n", resize);
		(void) scbuf_resize(0x123, bp, resize);

		cpinsize = maxsize / (rand() % 3 + 1);
		printf("[COPY_IN  ----- cpinsize=%d -----]\n", cpinsize);
		rest = scbuf_copy_from_user(bp, 0, buf0, cpinsize);

		if (rest >= 0) {
			cpoutsize = cpinsize - rest;
			printf("[COPY_OUT ----- cpoutsize=%d -----]\n",
				cpoutsize);
			rest = scbuf_copy_to_user(bp, 0, buf1, cpoutsize);
			if (rest || memcmp(buf0, buf1, cpoutsize)) {
				fprintf(stderr, "!!!!!! FAILED !!!!!!!!\n");
				exit(1);
			}
		}

		iosize	= maxsize / (rand() % 3 + 1);
		printf("[PREPARE  ----- iosize=%d -----]\n", iosize);
		(void) scbuf_prepare_for_io(&sglist, bp, iosize);

		if (bp) {
			printf("[FREE     ----- -----]\n");
			scbuf_free(bp);
		}
		printf("\n");
	}
}
