/*  


		bits of carry.c not under nda.



*/




// SSFDC_ callback for getting Vendor&Device.
//
int	carry_ssfdc_get_device_id_func(struct ssfdc_card_info *ssfdci,unsigned char *VendorID,unsigned char *DeviceID)
{
	// Get Smartmedia Device&Vwendor
	//
	unsigned char	command[] = { ... };
	unsigned char	reply[2];
	int 			rc;

	struct us_data	*us;

	us = (struct us_data *)ssfdci->access_device;
	if (!us )
		return SSFDC_NOT_INITIALISED;

	if( carry_wait_ready(us,CARRYS_SM_PRESENT) != USB_STOR_TRANSPORT_GOOD )
		return SSFDC_FAILED_NO_CARD;
		

	rc = carry_send_cmd(us, command);
	if (rc != USB_STOR_TRANSPORT_GOOD)
		return SSFDC_FAILED_CARD_ACCESS;

	// we'll go ahead and extract the media capacity while we're here...
	//
	rc = carry_bulk_read(us, reply, sizeof(reply));
	if( rc != USB_STOR_TRANSPORT_GOOD )
		return SSFDC_FAILED_CARD_ACCESS;


	*VendorID	= reply[0];
	*DeviceID	= reply[1];

	return SSFDC_OK;
}

int	carry_ssfdc_read_redundancy_func(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size)
{
	// Get Smartmedia Device&Vwendor
	//
	unsigned char	command[8] = { ...  };
	int 			rc;
	int				linpage;

	struct us_data	*us;

	us = (struct us_data *)ssfdci->access_device;
	if (!us )
		return SSFDC_NOT_INITIALISED;

	linpage = block << ssfdci->geo.blockshift | page;
	if( ssfdci->geo.capacity < 64*1024*1024 ){

	...

	}else{

	...
	}

	rc = carry_send_cmd(us, command);
	if (rc != USB_STOR_TRANSPORT_GOOD)
		return SSFDC_FAILED_CARD_ACCESS;

	// Get the data back.
	//
	rc = carry_bulk_read(us, data, size);
	if( rc != USB_STOR_TRANSPORT_GOOD )
		return SSFDC_FAILED_CARD_ACCESS;

	return SSFDC_OK;
}

int	carry_ssfdc_read_data_func(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size)
{
	// Get Smartmedia Device&Vwendor
	//
	unsigned char	command[8] = { ... };
	int 			rc;
	int				linpage;

	struct us_data	*us;

	us = (struct us_data *)ssfdci->access_device;
	if (!us )
		return SSFDC_NOT_INITIALISED;

	linpage = block << ssfdci->geo.blockshift | page;
	if( ssfdci->geo.capacity < 64*1024*1024 ){
...
	}else{
...
	}

	rc = carry_send_cmd(us, command);
	if (rc != USB_STOR_TRANSPORT_GOOD)
		return SSFDC_FAILED_CARD_ACCESS;

	// Get the data back.
	//
	rc = carry_bulk_read(us, data, size);
	if( rc != USB_STOR_TRANSPORT_GOOD )
		return SSFDC_FAILED_CARD_ACCESS;

	return SSFDC_OK;
}







// SmartMedia Transport for Carry Readers.
//
int carry_transport_sm(Scsi_Cmnd * srb, struct us_data *us)
{
	struct carry_info *info;
	unsigned long block, blocks;
	unsigned char *ptr = NULL;
	unsigned char inquiry_reply[36] = {
		0x00, 0x80, 0x00, 0x01, 0x1F, 0x00, 0x00, 0x00
	};
	int ssfdc_error;

	int	bytesize,sectors,secsize;


	info = (struct carry_info *)(us->extra);
	ptr  = (unsigned char *) srb->request_buffer;

	if (srb->cmnd[0] == INQUIRY) {
		US_DEBUGP("carry_sm:  INQUIRY.  Returning bogus response\n");
		memset( inquiry_reply + 8, 0, 28 );
		fill_inquiry_response(us, inquiry_reply, 36);
		return USB_STOR_TRANSPORT_GOOD;
	}

	if (srb->cmnd[0] == READ_CAPACITY) {

		// Get Device&Vendor ID + Mapping.
		//
    	ssfdc_error = ssfdc_detect_new_media( info->ssfdci );
    	if( ssfdc_error != SSFDC_OK )
    		return USB_STOR_TRANSPORT_FAILED;

		// build the reply
		//
		bytesize = ssfdc_get_formated_capacity( info->ssfdci );

		sectors = bytesize / 512;
		secsize = 512;

		US_DEBUGP("carry_sm:  READ_CAPACITY. %d bytes. %d sectory. Dev:%02x Vend:%02x.",
			bytesize,
			sectors,
			info->ssfdci->DeviceID,
			info->ssfdci->VendorID
		);

		ptr[0] = (sectors >> 24) & 0xFF;
		ptr[1] = (sectors >> 16) & 0xFF;
		ptr[2] = (sectors >>  8) & 0xFF;
		ptr[3] = (sectors      ) & 0xFF;

		ptr[4] = (secsize >> 24) & 0xFF;
		ptr[5] = (secsize >> 16) & 0xFF;
		ptr[6] = (secsize >>  8) & 0xFF;
		ptr[7] = (secsize      ) & 0xFF;

		return USB_STOR_TRANSPORT_GOOD;
	}

	if (srb->cmnd[0] == MODE_SELECT_10) {
		US_DEBUGP("carry_sm:  Gah! MODE_SELECT_10.\n");
		return USB_STOR_TRANSPORT_ERROR;
	}

	// don't bother implementing READ_6 or WRITE_6.  Just set MODE_XLATE and
	// let the usb storage code convert to READ_10/WRITE_10
	//
	if (srb->cmnd[0] == READ_10) {
		block = ((u32)(srb->cmnd[2]) << 24) | ((u32)(srb->cmnd[3]) << 16) |
		        ((u32)(srb->cmnd[4]) <<  8) | ((u32)(srb->cmnd[5]));

		blocks = ((u32)(srb->cmnd[7]) << 8) | ((u32)(srb->cmnd[8]));

		US_DEBUGP("carry_sm:  READ_10: read block 0x%04lx  count %ld\n", block, blocks);

		switch( ssfdc_read_data(info->ssfdci,block,blocks,ptr, srb->use_sg) ){
		case SSFDC_OK:
			return USB_STOR_TRANSPORT_GOOD;

		default:
    		return USB_STOR_TRANSPORT_FAILED;
		}
	}


	if (srb->cmnd[0] == READ_12) {
		// we'll probably never see a READ_12 but we'll do it anyway...
		//
		block = ((u32)(srb->cmnd[2]) << 24) | ((u32)(srb->cmnd[3]) << 16) |
		        ((u32)(srb->cmnd[4]) <<  8) | ((u32)(srb->cmnd[5]));

		blocks = ((u32)(srb->cmnd[6]) << 24) | ((u32)(srb->cmnd[7]) << 16) |
		         ((u32)(srb->cmnd[8]) <<  8) | ((u32)(srb->cmnd[9]));

		US_DEBUGP("carry_sm:  READ_12: read block 0x%04lx  count %ld\n", block, blocks);

		switch( ssfdc_read_data(info->ssfdci,block,blocks,ptr, srb->use_sg) ){
		case SSFDC_OK:
			return USB_STOR_TRANSPORT_GOOD;

		default:
    		return USB_STOR_TRANSPORT_FAILED;
		}
	}

	if (srb->cmnd[0] == TEST_UNIT_READY) {
		US_DEBUGP("carry_sm:  TEST_UNIT_READY.\n");

    	ssfdc_error = ssfdc_read_id( info->ssfdci );
    	if( ssfdc_error != SSFDC_OK )
    		return USB_STOR_TRANSPORT_FAILED;
    
    	return USB_STOR_TRANSPORT_GOOD;
	}

	if( srb->cmnd[0] == REQUEST_SENSE ){

		if( carry_wait_ready(us,CARRYS_SM_PRESENT) != USB_STOR_TRANSPORT_GOOD ){

			US_DEBUGP("carry_sm:  REQUEST_SENSE --> not ready !\n");

			// 04h 03h DTLPWRSOMCA E B K LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED

    		ptr[0]	= 0x70;
    		ptr[2]	= NOT_READY;
    		ptr[7]	= 11;
    		ptr[12]	= 0x04;
    		ptr[13]	= 0x03;
    
		}else{

			US_DEBUGP("carry_sm:  REQUEST_SENSE --> ready. (NO_SENSE)\n");

    		ptr[0]	= 0x70;
    		ptr[2]	= NO_SENSE;
    		ptr[7]	= 11;
    		ptr[12]	= 0x00;
    		ptr[13]	= 0x00;
		}
		return USB_STOR_TRANSPORT_GOOD;
	}

	if (srb->cmnd[0] == MODE_SENSE) {
		US_DEBUGP("carry_sm:  MODE_SENSE_6 detected\n");
		return carry_handle_mode_sense(us, srb, ptr, TRUE);
	}

	if (srb->cmnd[0] == MODE_SENSE_10) {
		US_DEBUGP("carry_sm:  MODE_SENSE_10 detected\n");
		return carry_handle_mode_sense(us, srb, ptr, FALSE);
	}

	if( srb->cmnd[0] == ALLOW_MEDIUM_REMOVAL) {

		// a.k.a PREVENT_ALLOW_MEDIUM_REMOVAL
		//
		switch( srb->cmnd[4] & 0x03 ){
		case 0:
			// Make shure we build new mappings with new device...
			//
			US_DEBUGP("carry_sm:    ALLOW_MEDIUM_REMOVAL 0 --> device unlocked.\n");

	//		ssfdc_delete_mapping( info->ssfdci );
			break;

		default:
			US_DEBUGP("carry_sm:    ALLOW_MEDIUM_REMOVAL !=0 --> system want's device locked. But how ?\n");
			break;
		}

		return USB_STOR_TRANSPORT_GOOD;
	}


	if( srb->cmnd[0] == START_STOP) {

		if( srb->cmnd[4] & 0x01 ){
			// Make shure we build new mappings with new device...
			//
			US_DEBUGP("carry_sm:   START_STOP 1 (%02x) --> Start LUN.\n",srb->cmnd[4]);

	//		ssfdc_delete_mapping( info->ssfdci );
		}else{
			US_DEBUGP("carry_sm:   START_STOP 0 (%02x) --> Stop LUN.\n",srb->cmnd[4]);
		}

		return USB_STOR_TRANSPORT_GOOD;
	}

	US_DEBUGP("carry_sm:  Gah! Unknown command: %d (0x%x)\n", srb->cmnd[0], srb->cmnd[0]);
	return USB_STOR_TRANSPORT_ERROR;
}







void carry_info_destructor(void *extra)
{
	struct carry_info *info;

	if(!extra)
		return;

	info = (struct carry_info *)extra;

	// Get rid of SamrtMedia management infos...
	//
	if( info->ssfdci ){
		ssfdc_delete( info->ssfdci );
		info->ssfdci = 0;
	}
}

int carry_info_creator(struct us_data *us)
{
	struct carry_info *info;

	us->extra = kmalloc(sizeof(struct carry_info), GFP_KERNEL);
	if (!us->extra) {
		US_DEBUGP("carry_transport:  Gah! Can't allocate storage for Carry info struct!\n");
		return 0;
	}
	memset(us->extra, 0, sizeof(struct carry_info));
	us->extra_destructor = carry_info_destructor;

	info = (struct carry_info *)us->extra;
	info->ssfdci = ssfdc_create(us);
	if( !info->ssfdci ){
		US_DEBUGP("carry_transport:  Gah! Can't allocate ssfdc control struct!\n");
		return 0;
	}

	// Set some func's we have...
	//
	info->ssfdci->get_device_id_func	= carry_ssfdc_get_device_id_func;
	info->ssfdci->read_redundancy_func	= carry_ssfdc_read_redundancy_func;
	info->ssfdci->read_data_func		= carry_ssfdc_read_data_func;

	info->ssfdci->funcs_valid = 1;

	return 1;
}




// Transport for Carry readers.
//
// does the lun mapping...
//
int carry_transport(Scsi_Cmnd * srb, struct us_data *us)
{
    if(	srb == NULL	)
		return USB_STOR_TRANSPORT_ERROR;
    	
	if( !us->extra ){
		if(!carry_info_creator(us))
			return USB_STOR_TRANSPORT_ERROR;
	}

	US_DEBUGP("carry_transport: LUN=%d\n", srb->lun);

  	switch(srb->lun) {
  	case 0:
		return carry_transport_cf(srb,us);

  	case 1:
		return carry_transport_sm(srb,us);

  	default:
    	US_DEBUGP("dpcm_transport: Invalid LUN %d\n", srb->lun);
    	return USB_STOR_TRANSPORT_ERROR;
  	}
}


										



