/*

ssfdc_mgr.h

SSFDC Abstract Management.


*/
#ifndef _SSFDC_MGR_H_INCLUDED
#define _SSFDC_MGR_H_INCLUDED 1


#define SSFDC_OK					0
#define SSFDC_NOT_INITIALISED		1
#define	SSFDC_NO_MEMORY				2
#define SSFDC_CARD_UNKNOWN			3
#define SSFDC_CARD_UNSUPPORTED		4
#define SSFDC_FAILED_NO_CARD		5
#define SSFDC_FAILED_CARD_ACCESS	6
#define SSFDC_FAILED_NO_MAPPING		7
#define SSFDC_CANT_WRITE_ROM		8



// SSFDC Attributes derived from device-id.
//
#define SSFDCA_PAGE256		0x0001
#define SSFDCA_PAGE512		0x0002
#define SSFDCA_FLASH		0x0004
#define SSFDCA_ROM			0x0008
#define SSFDCA_MULTIZONE	0x0010

//
//
typedef struct ssfdc_geometry {

	// direct results out of the Device-ID:
	//
	int		attributes;

	unsigned long	capacity;		// Size of card in bytes
	int		pagesize;		// Size of page in bytes
	int		pageshift;		// log2 of pagesize

	int		blocksize;		// Size of block in pages 
	int		blockshift;		// log2 of blocksize 
	int		blockmask;		// 2^blockshift - 1

	int		physblocks;		// 256,512,1024
	int		logblocks;		// 250,500,1000
	int		zones;			// 1,2,4,8

} ssfdc_geometry_t, *pssfdc_geometry;



// Other posbbile values in the pba_to_lba[] array..
//
// assume at least 31 unsigned bits in an int.
//
#define SSFDCPB_UNKNOWN	0
#define SSFDCPB_VALID	1
#define SSFDCPB_EMPTY	2
#define SSFDCPB_BAD		3		// Block contains garbage.
#define SSFDCPB_DAMAGED	4		// Block is marked as stuffed.


// should be abstract class SSFDCBasics...
//
typedef struct ssfdc_card_info {

	// Something that has access to the ssfdc card.
	//
	void		*access_device;

	// Vendor of the SSFDC & Device Code.
	//
	unsigned char		VendorID;
	unsigned char		DeviceID;

	struct ssfdc_geometry	geo;

	// Data unique to the content of this card:
	//
	int			*lba_to_pba;		// logical to physical map: 0..geo.logblocks-1
	char		*pba_status;		// status of each block: 0..geo.physblocks-1


	// For the paranoid: set this after all xxx_func() have been initialised.
	//
	int		funcs_valid;


		// Get Card's id.
		//
	int	(*get_device_id_func)(struct ssfdc_card_info *ssfdci,unsigned char *VendorID,unsigned char *DeviceID);

		// Functions to read/write/copy complete 256+8/512+16 sectors (data+redundancy)
		//
		// Size in bytes.
		// Reading multiple pages within 1 block must be supported.
		//
	int	(*read_raw_sector_func)(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size);
	int	(*write_raw_sector_func)(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size);
	int	(*copy_raw_sector_func)(struct ssfdc_card_info *ssfdci,int sourceblock,int sourcepage,int destblock);

		// Erase a block after it's been copied somewhere else..
		//
	int	(*erase_block_func)(struct ssfdc_card_info *ssfdci,int block);

		// Read data only or redundancy only.
		//
		// Multiple sectors ok, but don't cross block boundarys.
		//
	int	(*read_data_func)(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size);
	int	(*read_redundancy_func)(struct ssfdc_card_info *ssfdci,int block,int page,char *data,int size);

} ssfdc_card_info_t, *pssfdc_card_info;


//
//
extern struct ssfdc_card_info *ssfdc_create(void *forDevice);
extern void ssfdc_delete(struct ssfdc_card_info *ssfdci);
extern void ssfdc_delete_mapping(struct ssfdc_card_info *ssfdci);

extern int ssfdc_determine_card_params(struct ssfdc_card_info *ssfdci,unsigned char VendorID,unsigned char DeviceID);
extern int ssfdc_build_mapping(struct ssfdc_card_info *ssfdci);

extern int ssfdc_detect_new_media(struct ssfdc_card_info *ssfdci);
extern int ssfdc_get_formated_capacity(struct ssfdc_card_info *ssfdci);

extern int ssfdc_read_id(struct ssfdc_card_info *ssfdci);
extern int ssfdc_read_data(struct ssfdc_card_info *ssfdci,unsigned long sector,unsigned short sectors,unsigned char *content,int use_sg);



#endif

