/* 
 * programm for measuring update speed of USBDMX
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "usbdmx.h"

#define t 0.1  /* time constant for integration */

#define DEVICE "/dev/usb/usbdmx"

void timer(int);
int frames = 0;
int f;

int main()
{
  struct sigaction act;
  struct itimerval value;
  sigset_t sigset;
  
  /* init dmx stuff */
  int i;
  //int slots;
  //unsigned char buf[512];
  unsigned char buf[128];

  f = open(DEVICE, O_RDWR);

  if (f == -1) {
    char str[128];
    sprintf(str, "Error open device \"%s\"", DEVICE);
    perror(str);
    exit(0);
  }

  for(i=0; i<sizeof(buf); ++i)
    buf[i]=0;
 
  /* init timer */
  act.sa_handler = timer; /* Subroutine, die der Timer aufruft */
  sigprocmask(SIG_BLOCK, 0, &sigset);
  act.sa_mask = sigset;
  act.sa_flags = 0;

  value.it_interval.tv_sec = 1;  /* Zeit [sec], dach der die Routine aufgerufen wird */
  value.it_interval.tv_usec = 0; /* Zeit [msec], ... */
  value.it_value.tv_sec = 1;     /* ... */
  value.it_value.tv_usec = 0;    /* ... */
  
  /* Ativitt bei Signal festlegen... */
  sigaction(SIGALRM, &act, 0);
  
  /* Timer starten */
  setitimer(ITIMER_REAL, &value, 0);

  /* main loop */
  while(1) {
#if 1
    /* blocking or not... */
    ioctl(f, DMX_BLOCKING_SET, 0);

    /* select memory map */
    ioctl(f, DMX_MEM_MAP_SET, DMX_RC_MEM);
    /* move to beginning of map */
    lseek(f, 0, SEEK_SET);
    /* write data */
    read(f, buf, sizeof(buf));

    //    if((slots = ioctl(f, DMX_RC_SLOTS_GET)) != 512)
    //  printf("\nERROR: #received slots not constant: %3i\n", slots);
#endif
#if 1
    /* blocking or not... */
    ioctl(f, DMX_BLOCKING_SET, 0);

    /* select memory map */
    ioctl(f, DMX_MEM_MAP_SET, DMX_TX_MEM);
    /* move to beginning of map */
    lseek(f, 0, SEEK_SET);
    /* write data */
    write(f, buf, sizeof(buf));
#endif
    frames++;

    putchar('#');
    fflush(stdout);
  }

  return 0;
}

void timer(int c)
{
  /* Timersubroutine */
  static int i=0;
  static double mean = 0;
  static int conf = 0;
  static int k = 0;
  int fps = frames - i;
  int j = 70 - fps;

  if(mean > 0)
    mean = mean * (1.0 - t) + fps * t;
  else
    mean = fps;
  
  if(j > 0)
    while(j--)
      putchar(' ');

  printf("   fps: %2i, mean: %4.1f\n", fps, mean);
  i = frames--;

  if(++k > 5) {
    k = 0;
    conf = ++conf & 0x03;
    //ioctl(f, CONFIG_SET, conf);
  }
}
